
log using $folder/code/log_tax_peer, replace



***************************************
* Fig. 2. Fraction of self-nominations
***************************************
use $folder/data/cleaned.dta, replace

keep if period == 11 & (treatment==1|treatment==4) & voteattitude != -1
bys voteattitude: egen perc = mean(firstvotertry)
tab firstvotertry voteattitude
graph hbar perc, over(voteattitude) ylabel(0(0.2)1) scale(1.3) ytitle("Fraction of whom self-nominated as first voters") ///
legend(off) scheme(s1mono)
graph export $folder/output/figures/figure2.png, replace


************************************
* Fig. 3. % of yes in both ballots
************************************
use $folder/data/cleaned.dta, replace

// drop markets with no voluntary leader in Self-Nomination treatments when analyzing the vote data
bys group: gen fvTry = (firstvotertry == 1 & period == 11)
bys group: egen fvTryGroup = sum(fvTry) if period == 11
bys group subject (period): replace fvTryGroup = fvTryGroup[11] if _n!=11
drop if fvTryGroup == 0 & (treatment == 1|treatment == 4) 

keep if period == 11 | period == 16
replace vote = vote * 100
collapse (mean) mean_vote = vote (sd) sd_vote = vote (count) n = vote, by(treatment period)
gen ur_vote = mean_vote + sqrt(sd_vote ^ 2 / n)
gen lr_vote = mean_vote - sqrt(sd_vote ^ 2 / n)
gen x = 0.1 if treatment == 3 & period == 11
replace x = 0.9 if treatment == 3 & period == 16
replace x = 2.1 if treatment == 1 & period == 11
replace x = 2.9 if treatment == 1 & period == 16
replace x = 4.1 if treatment == 4 & period == 11
replace x = 4.9 if treatment == 4 & period == 16
gen mean_string = string(mean_vote, "%9.0f")
twoway (bar mean_vote x if period == 11, barwidth(.7) bfcolor(gs1)) ///
       (bar mean_vote x if period == 16, barwidth(.7) bfcolor(gs13)) ///
	   (rcap ur_vote lr_vote x, lcolor("black")) ///
	   (scatter mean_vote x, msym(none) mlab(mean_string) mlabsize(medium) mlabpos(1) mlabcolor(black)), ///
	   legend(row(2) pos(11) ring(0) order(1 "First ballot" 2 "Second ballot")) ///
	   xtitle("") xlabel(0.5 "No First Voter" 2.5 "Self-Nomination" 4.5 `" "Self-Nomination" "Asymmetric Information" "', noticks) ///
	   ytitle("% of yes votes") ylabel(0(20)100) ///
	   ysize(4) xsize(6) scale(1.1) scheme(s1mono)
graph export $folder/output/figures/figure3.png, replace



***************************************************
* Table 2. Frequency of self-nominations by treatment 
* (Note: this table is constructed manually from the output below)
***************************************************
use $folder/data/cleaned.dta, replace
keep if period==11
// column 1 for Self-Nomination (output from top to bottom)
count if treatment==1 
count if treatment==1 & voteattitude>4
count if treatment==1 & voteattitude>4 & firstvotertry==1
count if treatment==1 & voteattitude==4
count if treatment==1 & voteattitude==4 & firstvotertry==1
count if treatment==1 & voteattitude<4
count if treatment==1 & voteattitude<4 & firstvotertry==1
count if treatment==1 & firstvotertry==1

// column 2 and 3, top and bottom combined columns
count if treatment==4 // Total number of buyers
count if treatment==4 & firstvotertry==1  // Total number of self-nominations

// column 2 for Self-Nomination Asymmetric Information, Received info=Yes (output from top to bottom)
preserve 
keep if freeinfo==1
count if treatment==4 & voteattitude>4
count if treatment==4 & voteattitude>4 & firstvotertry==1
count if treatment==4 & voteattitude==4
count if treatment==4 & voteattitude==4 & firstvotertry==1
count if treatment==4 & voteattitude<4
count if treatment==4 & voteattitude<4 & firstvotertry==1
restore

// column 3 for Self-Nomination Asymmetric Information, Received info=No (output from top to bottom)
preserve 
keep if freeinfo==0
count if treatment==4 & voteattitude>4
count if treatment==4 & voteattitude>4 & firstvotertry==1
count if treatment==4 & voteattitude==4
count if treatment==4 & voteattitude==4 & firstvotertry==1
count if treatment==4 & voteattitude<4
count if treatment==4 & voteattitude<4 & firstvotertry==1
restore




*******************************************
* Table 3. Regressions of self-nominations
*******************************************
use $folder/data/cleaned.dta, replace

eststo: reg firstvotertry ib3.voteattitude if period==11&(treatment==1|treatment==4), cluster(group)
esttab, b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) brackets
esttab using $folder/output/tables/table3.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
eststo clear 




***************************************
* Fig.B2 Market Quantity by tax regime 
***************************************
use $folder/data/cleaned.dta, replace
bys treatment tax period: egen avqt = mean(qt) if period > 0

twoway (line avqt period if treatment==3 & tax == 60,sort lpattern(solid)) ///
(line avqt period if treatment==3 & tax == 0,sort lpattern(dash)), ///
legend(label(1 "with tax") label(2 "without tax") ring(0) row(1)) ///
ytitle("Average Market Quantity") ylabel(0(2)12, grid) ///
xtitle("Trading Period") title("No First Voter") scheme(s1mono)
graph save $folder/data/temp/1.gph, replace

twoway (line avqt period if treatment==1 & tax == 60,sort lpattern(solid)) ///
(line avqt period if treatment==1 & tax == 0,sort lpattern(dash)), ///
legend(label(1 "with tax") label(2 "without tax") ring(0) row(1)) ///
ytitle("Average Market Quantity") ylabel(0(2)12, grid) ///
xtitle("Trading Period") title("Self-Nomination") scheme(s1mono)
graph save $folder/data/temp/2.gph, replace

twoway (line avqt period if treatment==4 & tax == 60,sort lpattern(solid)) ///
(line avqt period if treatment==4 & tax == 0,sort lpattern(dash)), ///
legend(label(1 "with tax") label(2 "without tax") ring(0) row(1)) ///
ytitle("Average Market Quantity") ylabel(0(2)12, grid) ///
xtitle("Trading Period") title("Self-Nomination (Asym. Info.)") scheme(s1mono)
graph save $folder/data/temp/3.gph, replace

graph combine $folder/data/temp/1.gph $folder/data/temp/2.gph $folder/data/temp/3.gph , ///
row(3) ysize(2) xsize(1) ycommon scale(1.5) scheme(s1mono) 

graph export $folder/output/figures/figureB2.png, replace



***************************************
* Fig. C1. Fraction of buyers who self-nominated as first voters by initial attitude
***************************************
use $folder/data/cleaned.dta, replace

keep if period == 11 & treatment==1 & voteattitude != -1
bys voteattitude: egen perc = mean(firstvotertry)
tab firstvotertry voteattitude
graph hbar perc, over(voteattitude) ylabel(0(0.2)1) scale(1.3) ytitle("Fraction of whom self-nominated as first voters") ///
legend(off) scheme(s1mono)
graph export $folder/output/figures/figureC1a.png, replace

use $folder/data/cleaned.dta, replace

keep if period == 11 & treatment==4 & voteattitude != -1
bys voteattitude: egen perc = mean(firstvotertry)
tab firstvotertry voteattitude
graph hbar perc, over(voteattitude) ylabel(0(0.2)1) scale(1.3) ytitle("Fraction of whom self-nominated as first voters") ///
legend(off) scheme(s1mono)
graph export $folder/output/figures/figureC1b.png, replace



*******************************************
* Table C1. Initial attitudes and actual votes in the first ballot Self-Nomination treatment
* (Note: this table is constructed manually from the output below)
*******************************************
use $folder/data/cleaned.dta, replace
// drop markets with no voluntary leader in Self-Nomination treatments when analyzing the vote data
bys group: gen fvTry = (firstvotertry == 1 & period == 11)
bys group: egen fvTryGroup = sum(fvTry) if period == 11
bys group subject (period): replace fvTryGroup = fvTryGroup[11] if _n!=11
drop if fvTryGroup == 0 & (treatment == 1|treatment == 4) 

gen voteattitude3 = 1 if voteattitude<4
replace voteattitude3 = 2 if voteattitude==4
replace voteattitude3 = 3 if voteattitude>4

keep if period == 11 & (treatment==1|treatment==4) & voteattitude != -1

// column 1 for First Voters voted yes
* top panel
bys voteattitude: count if treatment==1 & firstvoter==1 & vote==1 // this code produces the "total number of buyers" and "number of yes votes" from top to bottom 
* middle panel
bys voteattitude3: count if treatment==1 & firstvoter==1 & vote==1 // this code produces the "total number of buyers" and "number of yes votes" from top to bottom
* bottom panel
count if treatment==1 & firstvoter==1 & vote==1 // this code produces the "total number of buyers" and "number of yes votes" from top to bottom

// column 2 for Followers
* top panel
bys voteattitude: count if treatment==1 & fvYesGroup==1 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude: count if treatment==1 & fvYesGroup==1 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* middle panel
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* bottom panel
count if treatment==1 & fvYesGroup==1 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
count if treatment==1 & fvYesGroup==1 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom

// column 3 for First Voters voted no
* top panel
bys voteattitude: count if treatment==1 & firstvoter==1 & vote==0 // this code produces the "total number of buyers" from top to bottom; "number of yes votes" = 0 in this column by design
* middle panel
bys voteattitude3: count if treatment==1 & firstvoter==1 & vote==0 // this code produces the "total number of buyers" from top to bottom; "number of yes votes" = 0 in this column by design
* bottom panel
count if treatment==1 & firstvoter==1 & vote==0 // this code produces the "total number of buyers" from top to bottom; "number of yes votes" = 0 in this column by design

// column 4 for Followers
* top panel
bys voteattitude: count if treatment==1 & fvYesGroup==0 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude: count if treatment==1 & fvYesGroup==0 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* middle panel
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* bottom panel
count if treatment==1 & fvYesGroup==0 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
count if treatment==1 & fvYesGroup==0 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom



******************************************
* Table C2. Initial attitudes and actual votes in the first ballot Self-Nomination Asymmetric Information treatment
* (Note: this table is constructed manually from the output below)
*******************************************
use $folder/data/cleaned.dta, replace
// drop markets with no voluntary leader in Self-Nomination treatments when analyzing the vote data
bys group: gen fvTry = (firstvotertry == 1 & period == 11)
bys group: egen fvTryGroup = sum(fvTry) if period == 11
bys group subject (period): replace fvTryGroup = fvTryGroup[11] if _n!=11
drop if fvTryGroup == 0 & (treatment == 1|treatment == 4) 

gen voteattitude3 = 1 if voteattitude<4
replace voteattitude3 = 2 if voteattitude==4
replace voteattitude3 = 3 if voteattitude>4

keep if period == 11 & (treatment==1|treatment==4) & voteattitude != -1

// column 1 for First Voters voted yes
* top panel
bys voteattitude: count if treatment==4 & firstvoter==1 & vote==1 // this code produces the "total number of buyers" and "number of yes votes" from top to bottom 
* middle panel
bys voteattitude3: count if treatment==4 & firstvoter==1 & vote==1 // this code produces the "total number of buyers" and "number of yes votes" from top to bottom
* bottom panel
count if treatment==1 & firstvoter==4 & vote==1 // this code produces the "total number of buyers" and "number of yes votes" from top to bottom

// column 2 for Followers with Info
preserve 
keep if freeinfo==1
* top panel
bys voteattitude: count if treatment==4 & fvYesGroup==1 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude: count if treatment==4 & fvYesGroup==1 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* middle panel
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* bottom panel
count if treatment==4 & fvYesGroup==1 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
count if treatment==4 & fvYesGroup==1 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
restore

// column 3 for Followers with no Info
preserve 
keep if freeinfo==0
* top panel
bys voteattitude: count if treatment==4 & fvYesGroup==1 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude: count if treatment==4 & fvYesGroup==1 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* middle panel
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* bottom panel
count if treatment==4 & fvYesGroup==1 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
count if treatment==4 & fvYesGroup==1 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
restore

// column 4 for First Voters voted no
* top panel
bys voteattitude: count if treatment==4 & firstvoter==1 & vote==0 // this code produces the "total number of buyers" from top to bottom; "number of yes votes" = 0 in this column by design
* middle panel
bys voteattitude3: count if treatment==4 & firstvoter==1 & vote==0 // this code produces the "total number of buyers" from top to bottom; "number of yes votes" = 0 in this column by design
* bottom panel
count if treatment==1 & firstvoter==4 & vote==0 // this code produces the "total number of buyers" from top to bottom; "number of yes votes" = 0 in this column by design

// column 5 for Followers with Info
preserve 
keep if freeinfo==1
* top panel
bys voteattitude: count if treatment==4 & fvYesGroup==0 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude: count if treatment==4 & fvYesGroup==0 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* middle panel
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* bottom panel
count if treatment==4 & fvYesGroup==0 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
count if treatment==4 & fvYesGroup==0 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
restore

// column 6 for Followers with no Info
preserve 
keep if freeinfo==0
* top panel
bys voteattitude: count if treatment==4 & fvYesGroup==0 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude: count if treatment==4 & fvYesGroup==0 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* middle panel
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
* bottom panel
count if treatment==4 & fvYesGroup==0 & firstvoter!=1 & vote==1 // this code produces the "number of yes votes" from top to bottom
count if treatment==4 & fvYesGroup==0 & firstvoter!=1 // this code produces the "total number of buyers" from top to bottom
restore



*******************************************
* Table C3. Regressions of self-nominations
*******************************************
use $folder/data/cleaned.dta, replace

eststo: reg firstvotertry ib3.voteattitude if period==11 & treatment==1, cluster(group)
eststo: reg firstvotertry ib3.voteattitude if period==11 & treatment==4, cluster(group)
esttab, b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) brackets
esttab using $folder/output/tables/tableC3.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
eststo clear 


*******************************************
* Table C4. Regressions of self-nominations
*******************************************
use $folder/data/cleaned.dta, replace

eststo: reg firstvotertry ib1.voteattitude if period==11&(treatment==1|treatment==4), cluster(group)
eststo: reg firstvotertry ib2.voteattitude if period==11&(treatment==1|treatment==4), cluster(group)
eststo: reg firstvotertry ib3.voteattitude if period==11&(treatment==1|treatment==4), cluster(group)
eststo: reg firstvotertry ib4.voteattitude if period==11&(treatment==1|treatment==4), cluster(group)
eststo: reg firstvotertry ib5.voteattitude if period==11&(treatment==1|treatment==4), cluster(group)
eststo: reg firstvotertry ib6.voteattitude if period==11&(treatment==1|treatment==4), cluster(group)
eststo: reg firstvotertry ib7.voteattitude if period==11&(treatment==1|treatment==4), cluster(group)
esttab, b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) brackets
esttab using $folder/output/tables/tableC4.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
eststo clear 



*******************************************
* Table E1. Ratio of “yes” votes in the first ballot by message content
* (Note: this table is constructed manually from the output below)
*******************************************
use $folder/data/cleaned.dta, replace
// drop markets with no voluntary leader in Self-Nomination treatments when analyzing the vote data
bys group: gen fvTry = (firstvotertry == 1 & period == 11)
bys group: egen fvTryGroup = sum(fvTry) if period == 11
bys group subject (period): replace fvTryGroup = fvTryGroup[11] if _n!=11
drop if fvTryGroup == 0 & (treatment == 1|treatment == 4) 

gen voteattitude3 = 1 if voteattitude<4
replace voteattitude3 = 2 if voteattitude==4
replace voteattitude3 = 3 if voteattitude>4

keep if period == 11 & (treatment==1|treatment==4) & voteattitude != -1 & firstvoter!=1

// column 1 for Self-Nomination, Explained why
* top panel
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & reason==1 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & reason==1  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & reason==1 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & reason==1  // this code produces the "total number of buyers" from top to bottom

// column 2 for Self-Nomination, Statement only
* top panel
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & reason==2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & reason==2  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & reason==2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & reason==2  // this code produces the "total number of buyers" from top to bottom

// column 3 for Self-Nomination, Other or no reason
* top panel
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & reason>2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & reason>2  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & reason>2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & reason>2  // this code produces the "total number of buyers" from top to bottom

// column 4 for Self-Nomination Asymmetric Information, Explained why
* top panel
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & reason==1 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & reason==1  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & reason==1 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & reason==1  // this code produces the "total number of buyers" from top to bottom

// column 5 for Self-Nomination Asymmetric Information, Statement only
* top panel
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & reason==2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & reason==2  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & reason==2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & reason==2  // this code produces the "total number of buyers" from top to bottom

// column 6 for Self-Nomination Asymmetric Information, Other or no reason
* top panel
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & reason>2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & reason>2  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & reason>2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & reason>2  // this code produces the "total number of buyers" from top to bottom


*******************************************
* Table E2. Ratio of “yes” votes in the first ballot by confidence
* (Note: this table is constructed manually from the output below)
*******************************************
use $folder/data/cleaned.dta, replace
// drop markets with no voluntary leader in Self-Nomination treatments when analyzing the vote data
bys group: gen fvTry = (firstvotertry == 1 & period == 11)
bys group: egen fvTryGroup = sum(fvTry) if period == 11
bys group subject (period): replace fvTryGroup = fvTryGroup[11] if _n!=11
drop if fvTryGroup == 0 & (treatment == 1|treatment == 4) 

gen voteattitude3 = 1 if voteattitude<4
replace voteattitude3 = 2 if voteattitude==4
replace voteattitude3 = 3 if voteattitude>4

keep if period == 11 & (treatment==1|treatment==4) & voteattitude != -1 & firstvoter!=1

// column 1 for Self-Nomination, Confident
* top panel
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & confidence==1 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & confidence==1  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & confidence==1 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & confidence==1  // this code produces the "total number of buyers" from top to bottom

// column 2 for Self-Nomination, Not confident
* top panel
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & confidence==2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & confidence==2  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & confidence==2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & confidence==2  // this code produces the "total number of buyers" from top to bottom

// column 3 for Self-Nomination, No information
* top panel
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & confidence>2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==1 & confidence>2  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & confidence>2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==1 & fvYesGroup==0 & confidence>2  // this code produces the "total number of buyers" from top to bottom

// column 4 for Self-Nomination Asymmetric Information, Confident
* top panel
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & confidence==1 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & confidence==1  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & confidence==1 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & confidence==1  // this code produces the "total number of buyers" from top to bottom

// column 5 for Self-Nomination Asymmetric Information, Not confident
* top panel
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & confidence==2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & confidence==2  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & confidence==2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & confidence==2  // this code produces the "total number of buyers" from top to bottom

// column 6 for Self-Nomination Asymmetric Information, No information
* top panel
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & confidence>2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==1 & confidence>2  // this code produces the "total number of buyers" from top to bottom
* bottom panel
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & confidence>2 & vote==1  // this code produces the "number of yes votes" from top to bottom 
bys voteattitude3: count if treatment==4 & fvYesGroup==0 & confidence>2  // this code produces the "total number of buyers" from top to bottom



*******************************************
* Table F1. Regressions of followers’ voting decision,
*******************************************
use $folder/data/cleaned.dta, replace
sort sessionid subject period
bys sessionid subject: gen tax_exp = (tax[_n-1]==60 & period == 16)
keep if (treatment==1|treatment==4) & firstvoter!=1
eststo: reg vote i.votefv if period==11 & treatment==1, cluster(group)
eststo: reg vote i.votefv if period==11 & treatment==4, cluster(group)
eststo: reg vote i.votefv##i.treatment if period==11, cluster(group)
eststo: reg vote i.votefv i.tax_exp if period==16 & treatment==1, cluster(group)
eststo: reg vote i.votefv i.tax_exp if period==16 & treatment==4, cluster(group)
eststo: reg vote i.votefv##i.treatment i.tax_exp if period==16, cluster(group)
eststo: reg vote i.votefv##i.tax_exp if period==16 & treatment==1, cluster(group)
esttab, b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) brackets
esttab using $folder/output/tables/tableF1.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
eststo clear 



*******************************************
* Table G1. Regressions of self-nominations: Robustness
*******************************************
use $folder/data/cleaned.dta, replace

eststo: reg firstvotertry ib3.voteattitude female political1 if period==11&(treatment==1|treatment==4), cluster(group)
eststo: reg firstvotertry ib3.voteattitude female political1 age1 if period==11&(treatment==1|treatment==4), cluster(group)
eststo: reg firstvotertry ib3.voteattitude female political1 age1 drate if period==11&(treatment==1|treatment==4) & multiswitch!=1 & irregular!=1, cluster(group)
esttab, b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) brackets
esttab using $folder/output/tables/tableG1.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
eststo clear 



log close
