
********************************
* PREVENTIVE WAR DATA ANALYSIS *
********************************

*---------------------
*-> 0. Set Directories
*---------------------
// Note: These globals are set in 0PathSetup.do
// $folder: Root directory of replication package
// $data_folder: Path to data directory
// $code_folder: Path to code directory
// $output_folder: Path to output directory

global mydataS $data_folder
global mydataD $data_folder
global fromZtree $data_folder/fromZtree.dta
global mydata $data_folder/data.dta
global myfigs $output_folder/figures

cd $data_folder
set more off


*--------------------
*-> 1.1 DATA INPUTTING
*--------------------
*-1.1 From ztree to stata
	clear
	local filenames 231017_1239 231023_1302 231108_1306 ///
					231016_1451 231024_0906 231109_0912 ///
					231016_1240 231025_0910 231109_1307 ///
					231017_0941 231026_1311 231110_0904 ///
					231113_1257 231118_0931 231118_1310



	*-------------------------
	foreach file in `filenames'{
		cd $mydataS
		ztree2stata subjects using `file'.xls, clear
		gen mfix = 1
		cd $mydataD
		save `file', replace
	}
	*----------------------------

	clear
	append using `filenames', force

	save $fromZtree, replace

*--------------
* DATA CLEANING
*--------------

	*-1.2 Rename and Re-Modify
		use $fromZtree, clear
		cap drop tables treatment Participate
		cap drop qz*
		cap drop rn*
		cap drop winner*
		cap drop Time*
		cap drop ~*
		//cap drop Risk_Taking Competitive*
		//cap drop Description*
		cap drop mfix


		*-> treatment

		gen treatment = "1PreventiveWar" if session == "231017_1239"|session == "231023_1302" | session == "231108_1306"
		replace treatment = "2RS-Contain" if session == "231016_1451"|session == "231024_0906" | session == "231109_0912"
		replace treatment = "3RS-Commit" if session == "231016_1240" | session == "231025_0910" | session == "231109_1307"
		replace treatment = "4RS-Choice" if session == "231017_0941" | session == "231026_1311" | session == "231110_0904"
		replace treatment = "5DS-Contain" if session == "231113_1257" | session == "231118_0931" | session == "231118_1310"

		*-> rename

			rename Period period
			rename Profit profit
			rename type playerB
			egen pid = group(Subject session)
			egen groupid = group(Group session)
			egen mgroup = group(bigGroup session)

			order treatment period mgroup groupid pid playerB allo1a allo1b allo2a allo2b  profit reject*

		save $mydata, replace


		clear
		unicode encoding set "GB18030"
		cd $mydataD
		unicode translate data.dta



