# README for "Endogenous Preventive War: An Experimental Study"

## Overview

This replication package contains all materials needed to replicate the experimental results reported in "Curtailed Ambition: Endogenous Power Shift and Preventive War."

### Package Contents

This replication package includes:

- **Raw experimental data**: Complete output files from all z-Tree sessions
- **Analysis code**: STATA do-files for data cleaning and analysis
- **Experimental materials**: z-Tree program files for all treatments
- **Output**: Scripts to generate all figures and tables in the paper

### Treatments

The experiment includes the following treatments:

1. **PreventiveWar (PW-Baseline)**: Baseline treatment with no institutional mechanisms
2. **RS-Contain**: Rising State can choose to contain its capabilities
3. **RS-Commit**: Rising State can commit to a maximum allocation
4. **RS-Choice**: Rising State can choose between contain and commit
5. **DS-Contain**: Declining State's rival can contain Rising State's capabilities

## Data Availability

### Experimental Data

All experimental data were collected by the authors using z-Tree software. The data are provided in their original format as exported from z-Tree.

**Data Files:**
- `data/`: Excel files exported from z-Tree (14 session files: 231017_1239.xls, 231023_1302.xls, etc.)
- `experimental-materials/raw-output-from-ztree/`: Complete z-Tree output directories organized by treatment

**Data Provenance:**
- 14 sessions conducted in October-November 2023
- Each session involves multiple participants making decisions over 30 periods
- Each session lasted approximately 90-120 minutes

**Session Distribution by Treatment:**
- PreventiveWar: 3 sessions (231017_1239, 231023_1302, 231108_1306)
- RS-Contain: 3 sessions (231016_1451, 231024_0906, 231109_0912)
- RS-Commit: 3 sessions (231016_1240, 231025_0910, 231109_1307)
- RS-Choice: 3 sessions (231017_0941, 231026_1311, 231110_0904)
- DS-Contain: 2 sessions (231113_1257, 231118_0931, 231118_1310)

### Statement about Rights

- [x] I certify that the author(s) of the manuscript have legitimate access to and permission to use the data used in this manuscript.
- [x] I certify that the author(s) of the manuscript have documented permission to redistribute/publish the data contained within this replication package.

## Computational Requirements

### Software Requirements

- **Stata** (code was tested with version 16.0 or later)
  - Required packages: `estout`, `ztree2stata`, `grc1leg2`
  - Run `code/0PathSetup.do` to install all dependencies

- **z-Tree** (for viewing/modifying experimental software)
  - Version: z-Tree 3.6.7 or later
  - Files: `experimental-materials/software/*.ztt`

### Hardware Requirements

The analysis was last run on:
- MacBook Pro with Apple M3 processor, 16GB RAM
- Estimated runtime: < 5 minutes for complete analysis

### Storage Requirements

- Uncompressed package size: ~50 MB
- Temporary files during analysis: ~200 MB

## Description of Programs

### Code Organization

**Setup:**
- `code/0PathSetup.do`: Sets global paths and installs packages (run first)
  - Configures paths for data, code, and output directories
  - Installs required Stata packages

**Data Preparation:**
- `code/1DataClean.do`: Imports raw z-Tree data and constructs analysis dataset
  - Reads all 14 session files from `data/`
  - Creates treatment indicators (PreventiveWar, RS-Contain, RS-Commit, RS-Choice, DS-Contain)
  - Creates derived variables (player types, group IDs, period indicators)
  - Outputs: `data/data.dta`, `data/fromZtree.dta`

**Figures and Tables:**
- `code/2Analysis.do`: Generates all figures and tables in manuscript order (main text + appendix)
  - **MAIN TEXT (in order)**:
    - **TABLE 2**: Descriptive statistics on preventive war rates (outputs: `output/tables/table2.tex` and related files)
    - **TABLE 3**: Random effects probit regressions - RS-Contain vs RS-Commit (outputs: `output/tables/table3.tex`)
    - **FIGURE 2**: Policy choices over time (outputs: `output/figures/figure2.png`)
    - **FIGURE 3**: The frequency of preventive wars by policy choices (outputs: `output/figures/figure3.png`)
    - **FIGURE 4**: The rising state's and declining state's average payoffs (outputs: `output/figures/figure4.png`)
    - **TABLE 4**: Random effects probit regressions - RS-Choice (outputs: `output/tables/table4.tex`)
    - **TABLE 5**: Random effects probit regressions - DS-Contain (outputs: `output/tables/table5.tex`)
  - **APPENDIX (in order)**:
    - **TABLES C1-C6**: Robustness checks and payoff regressions (outputs: `output/tables/tablec1.tex` through `output/tables/tablec6.tex`)
    - **FIGURES C2-C15**: Time series and conditional analysis (outputs: `output/figures/figurec2.png` through `output/figures/figurec15.png`)
  - Note: Table 1 (experimental design), Table 6 (survey), and Figures 5-7 (survey) are not generated from experimental data

### Program Details

Each do-file can be run independently after `0PathSetup.do` has been executed. The files use the following global macros:

- `$folder`: Root directory of the replication package
- `$data_folder`: Path to data directory
- `$code_folder`: Path to code directory
- `$output_folder`: Path to output directory

## Instructions to Replicators

### Step-by-Step Instructions

1. **Extract the package** to a location on your computer

2. **Update the path** in `code/0PathSetup.do`:
   ```stata
   global folder "/path/to/replication-output"
   ```

3. **Install dependencies** by running:
   ```stata
   do code/0PathSetup.do
   ```

4. **Run the analysis** in order:
   ```stata
   do code/1DataClean.do
   do code/2Analysis.do
   ```

All outputs will be created in the `output/` directory.

### Reproducibility Notes

- **Random seed**: Not applicable (deterministic experimental design)
- **Software versions**: Code tested with Stata 16.0 on macOS
- **Known issues**: The `ztree2stata` package requires z-Tree data files to be in specific format

## List of Tables and Figures

The provided code reproduces all results in the paper:

**Main Text Figures:**
- Figure 2: Policy choices over time (`output/figures/figure2.png`)
- Figure 3: Frequency of preventive wars (`output/figures/figure3.png`)
- Figure 4: Average payoffs by treatment (`output/figures/figure4.png`)

**Main Text Tables:**
- Table 2: Descriptive statistics (`output/tables/table2.tex` and related files)
- Table 3: RS-Contain vs RS-Commit regression (`output/tables/table3.tex`)
- Table 4: RS-Choice regression (`output/tables/table4.tex`)
- Table 5: DS-Contain regression (`output/tables/table5.tex`)

**Appendix Figures (14 figures):**
- Figures C2-C15: Time series and conditional analysis (`output/figures/figurec2.png` through `output/figures/figurec15.png`)

**Appendix Tables (6 tables):**
- Tables C1-C6: Robustness checks and payoff regressions (`output/tables/tablec1.tex` through `output/tables/tablec6.tex`)

## Data Dictionary

### Key Variables in data.dta

- `treatment`: Categorical treatment indicator ("1PreventiveWar", "2RS-Contain", "3RS-Commit", "4RS-Choice", "5DS-Contain")
- `period`: Period number (1-30)
- `session`: Session identifier (YYMMDD_HHMM format)
- `subject`: Subject ID within session
- `group`: Group ID within session
- `mgroup`: Matched group ID
- `playerB`: Player type (0 = Rising State, 1 = Declining State)
- `allo1a`, `allo1b`: Stage 1 allocations
- `allo2a`, `allo2b`: Stage 2 allocations
- `reject1`: Binary indicator for preventive war (fighting) decision
- `profit`: Subject earnings
- `contain`: Containment decision (RS-Contain treatment)
- `commit`: Commitment decision (RS-Commit treatment)
- `choice`: Endogenous choice (RS-Choice treatment)
- `rival_contain`: Rival containment (DS-Contain treatment)
