
log using $folder/code/log_1dataclean, replace

use $folder/data/rawdata.dta, clear

egen mgroup = group(biggroup sessionid)
gen sid = mgroup*100+subject
gen gid = mgroup*100+group
gen tid = 6 if treatment=="Zero_T"
replace tid = 5 if treatment=="Zero_W"
replace tid = 4 if treatment=="Low_T"
replace tid = 3 if treatment=="Low_W"
replace tid = 2 if treatment=="Medium_TW"
replace tid = 1 if treatment=="High_TW"
replace tid = 7 if treatment=="High_Forced"

gen female1 = real(female)
gen age1 = real(age)
gen risk_taking1 = real(risk_taking)
gen competitive1 = real(competitive)
gen crt_score1 = real(crt_score)
bys treatment sid: egen female2 = max(female1)
bys treatment sid: egen age2 = max(age1)
bys treatment sid: egen risk_taking2 = max(risk_taking1)
bys treatment sid: egen competitive2 = max(competitive1)
bys treatment sid: egen crt_score2 = max(crt_score1)
drop female age risk_taking competitive crt_q1 crt_q2 crt_q3 crt_score
drop female1 age1 risk_taking1 competitive1 crt_score1
rename female2 female
rename age2 age
rename risk_taking2 risk_taking
rename competitive2 competitive
rename crt_score2 crt_score

bys treatment sid: egen risk = min(ra)
bys treatment sid: egen ambiguity = min(aa)
bys treatment sid: egen loss = min(la)

replace belief = belief - enter
replace belief = 0 if belief==-1
replace belief = 2 if belief==3
replace belief = 2 if belief==-2

gen t = 1.455 if treatment=="Zero_W" | treatment=="Medium_TW" | treatment=="Low_W"
replace t = 1.707 if treatment=="High_TW" | treatment=="High_Forced"
replace t = 1.218 if treatment=="Low_T"
gen hightype = (costrate>t)

gen costrate1 = ceil(costrate*10) / 10
bys treatment costrate1: egen av_bid = mean(bid)
bys treatment costrate1: egen av_enter_cost = mean(enter*100)
bys treatment costrate1: egen av_bid_entry_cost = mean(bid) if enter==1

gen last10 = (period>10)

gen abovecutoff = (bid >= cutoff)
bys treatment period: egen av_enter = mean(enter*100)
bys treatment period: egen av_bid_enter = mean(bid) if enter==1

gen positive_effort_below = (bid>0 & bid<cutoff)
gen effort_zero = (enter==1 & bid == 0)

bys treatment period gid: egen total_bid = sum(bid)
bys treatment period: egen total_bid_2 = mean(total_bid)
bys treatment period gid: egen max_bid = max(bid)
bys treatment period: egen max_bid_2 = mean(max_bid)

bys treatment period gid: egen high_produ = max(costrate)
gen effi = (costrate == high_produ & winner == 1)
bys treatment period gid: egen efficiency = sum(effi)
replace efficiency = 1 if efficiency == 2

gen profit = 300 if enter ==0
replace profit = 300 - entryfee - bid/costrate + contestprize if enter==1 & sumenter==1
replace profit = 300 - bid/costrate + 120 / sumenter if enter == 1 & sumenter > 1 & refund == 1
replace profit = 300 - entryfee - bid/costrate + contestprize / cowinner if enter == 1 & sumenter > 1 & refund == 0 & winner == 1
replace profit = 300 - entryfee - bid/costrate if enter == 1 & sumenter > 1 & refund == 0 & winner == 0
replace profit = 0 if treatment=="Zero_W"
replace profit = 300 if enter ==0 & treatment=="Zero_W"
replace profit = 300 - bid/costrate if enter==1 & refund==1 & treatment=="Zero_W"
replace profit = 300 - bid/costrate + contestprize / cowinner if enter == 1 & refund == 0 & winner == 1 & treatment=="Zero_W"
replace profit = 300 - bid/costrate if enter == 1 & refund == 0 & winner == 0 & treatment=="Zero_W"
replace profit = 0 if treatment=="Zero_T"
replace profit = 300 if enter ==0 & treatment=="Zero_T"
replace profit = 300 - bid/costrate + contestprize if enter==1 & sumenter==1 & treatment=="Zero_T"
replace profit = 300 - bid/costrate + contestprize / cowinner if enter == 1 & sumenter > 1 & winner == 1 & treatment=="Zero_T"
replace profit = 300 - bid/costrate if enter == 1 & sumenter > 1 & winner == 0 & treatment=="Zero_T"
replace profit = 0 if treatment=="Low_W"
replace profit = 300 if enter ==0 & treatment=="Low_W"
replace profit = 300 - bid/costrate + 24 / sumenter if enter == 1 & refund == 1 & treatment=="Low_W"
replace profit = 300 - entryfee - bid/costrate + contestprize / cowinner if enter == 1 & refund == 0 & winner == 1 & treatment=="Low_W"
replace profit = 300 - entryfee - bid/costrate if enter == 1 & refund == 0 & winner == 0 & treatment=="Low_W"

// counterfactual profit when every subject enters the contest
gen c_profit = 0
gen c_contestprize = 120 + 3*entryfee
gen c_refund = (bid1 < cutoff & bid2 < cutoff & bid3 < cutoff)
gen c_winner = (bid == highestbid & c_refund == 0)
bys sessionid period group: egen c_cowinner = sum(c_winner)

replace c_profit = 300 - bid/costrate + 120 / 3 if c_refund == 1
replace c_profit = 300 - entryfee - bid/costrate + c_contestprize / c_cowinner if c_refund == 0 & c_winner == 1
replace c_profit = 300 - entryfee - bid/costrate if c_refund == 0 & c_winner == 0
replace c_profit = 0 if treatment=="Zero_W"
replace c_profit = 300 - bid/costrate if c_refund==1 & treatment=="Zero_W"
replace c_profit = 300 - bid/costrate + c_contestprize / c_cowinner if c_refund == 0 & c_winner == 1 & treatment=="Zero_W"
replace c_profit = 300 - bid/costrate if c_refund == 0 & c_winner == 0 & treatment=="Zero_W"
replace c_profit = 0 if treatment=="Zero_T"
replace c_profit = 300 - entryfee - bid/costrate + c_contestprize / c_cowinner if c_winner == 1 & treatment=="Zero_T"
replace c_profit = 300 - entryfee - bid/costrate if c_winner == 0 & treatment=="Zero_T"

//bys treatment hightype enter: sum profit c_profit


// theoretical bid
gen bid_t = 0 if (treatment=="High_TW" | treatment=="High_Forced") & costrate < 1.707 
replace bid_t = -3*(40)*costrate^2 + 2*(40)*costrate^3 - 120*costrate^2 + 80*costrate^3 + 40 if (treatment=="High_TW" | treatment=="High_Forced") & costrate >= 1.707 

replace bid_t = 0 if treatment=="Medium_TW" & costrate < 1.455
replace bid_t = -3*(10.5)*costrate^2 + 2*(10.5)*costrate^3 - 120*costrate^2 + 80*costrate^3 + 40 if treatment=="Medium_TW" & costrate >= 1.455

replace bid_t = 0 if treatment=="Low_W" & costrate < 1.455
replace bid_t = 84*costrate^3 - 126*costrate^2 + 45.967 if treatment=="Low_W" & costrate >= 1.455

replace bid_t = 0 if treatment=="Low_T" & costrate < 1.218
replace bid_t = 84*costrate^3 - 126*costrate^2 + 42.436 if treatment=="Low_T" & costrate >= 1.218

replace bid_t = 0 if treatment=="Zero_W" & costrate < 1.455
replace bid_t = 80*costrate^3 - 120*costrate^2 + 43.778 if treatment=="Zero_W" & costrate >= 1.455

replace bid_t = 80*costrate^3 - 120*costrate^2 + 40 if treatment=="Zero_T" 

bys treatment period gid: egen max_bid_t = max(bid_t)
bys treatment period gid: egen total_bid_t = sum(bid_t)


save $folder/data/cleaned.dta, replace

log close
