

		
		log using $folder/code/log_1DataClean, replace
*===========================
		* clean clean clean 
*===========================

		use $folder/data/rawdata.dta, clear
		
		gen age1 = 1 if age == "18-20"
		replace age1 = 2 if age == "21-23"
		replace age1 = 3 if age == "24-26"
		replace age1 = 4 if age == "27 and above"

		gen female = (gendermf == "Female")

		gen political1 = 1 if political == "Conservative"
		replace political1 = 2 if political == "Liberal"
		replace political1 = 3 if political == "Moderate"
		replace political1 = 4 if political == "Very Conservative"
		replace political1 = 5 if political == "Very Liberal"
		
		// discount rate 
		encode r0, gen(nr0)
		encode r1, gen(nr1)
		encode r2, gen(nr2)
		encode r3, gen(nr3)
		encode r4, gen(nr4)
		encode r5, gen(nr5)
		encode r6, gen(nr6)
		encode r7, gen(nr7)
		encode r8, gen(nr8)
		
		replace nr0 = 20 if nr0==2
		replace nr1 = 20 if nr1==1
		replace nr2 = 20 if nr2==1
		replace nr3 = 20 if nr3==1
		replace nr4 = 20 if nr4==1
		replace nr5 = 20 if nr5==1
		replace nr6 = 20 if nr6==1
		replace nr7 = 20 if nr7==1
		replace nr8 = 20 if nr8==1
		
		gen d0 = (nr0==20)
		gen d1 = (nr1==20)
		gen d2 = (nr2==20)
		gen d3 = (nr3==20)
		gen d4 = (nr4==20)
		gen d5 = (nr5==20)
		gen d6 = (nr6==20)
		gen d7 = (nr7==20)
		gen d8 = (nr8==20)
		
		gen discount = d0+d1+d2+d3+d4+d5+d6+d7+d8 // 0: very patient; 8 very impatient
		
		gen multiswitch = 1 if d0==0&(d1==1|d2==1|d3==1|d4==1|d5==1|d6==1|d7==1|d8==1)
		replace multiswitch = 1 if d1==0&(d2==1|d3==1|d4==1|d5==1|d6==1|d7==1|d8==1)
		replace multiswitch = 1 if d2==0&(d3==1|d4==1|d5==1|d6==1|d7==1|d8==1)
		replace multiswitch = 1 if d3==0&(d4==1|d5==1|d6==1|d7==1|d8==1)
		replace multiswitch = 1 if d4==0&(d5==1|d6==1|d7==1|d8==1)
		replace multiswitch = 1 if d5==0&(d6==1|d7==1|d8==1)
		replace multiswitch = 1 if d6==0&(d7==1|d8==1)
		replace multiswitch = 1 if d7==0&(d8==1)
			
		gen irregular = 1 if r0=="$20.00 now;$20.00 in one week;"
		replace irregular = 1 if r1=="$20.00 now;$20.20 in one week;"
		replace irregular = 1 if r2=="$20.00 now;$20.60 in one week;"
		replace irregular = 1 if r3=="$20.00 now;$21.00 in one week;"
		replace irregular = 1 if r4=="$20.00 now;$21.40 in one week;"
		replace irregular = 1 if r5=="$20.00 now;$21.80 in one week;"
		replace irregular = 1 if r6=="$20.00 now;$22.00 in one week;"
		replace irregular = 1 if r7=="$20.00 now;$23.00 in one week;"
		replace irregular = 1 if r8=="$20.00 now;$24.00 in one week;"
				
		bysort subject: gen drate = .
		bysort subject: replace drate = 0    if (nr1!=20 & nr2!=20 & nr3!=20 & nr4!=20 & nr5!=20 & nr6!=20 & nr7!=20 & nr8!=20)
		bysort subject: replace drate = 0.01 if (nr1==20 & nr2!=20 & nr3!=20 & nr4!=20 & nr5!=20 & nr6!=20 & nr7!=20 & nr8!=20)
		bysort subject: replace drate = 0.03 if (nr1==20 & nr2==20 & nr3!=20 & nr4!=20 & nr5!=20 & nr6!=20 & nr7!=20 & nr8!=20)
		bysort subject: replace drate = 0.05 if (nr1==20 & nr2==20 & nr3==20 & nr4!=20 & nr5!=20 & nr6!=20 & nr7!=20 & nr8!=20)
		bysort subject: replace drate = 0.07 if (nr1==20 & nr2==20 & nr3==20 & nr4==20 & nr5!=20 & nr6!=20 & nr7!=20 & nr8!=20)
		bysort subject: replace drate = 0.09 if (nr1==20 & nr2==20 & nr3==20 & nr4==20 & nr5==20 & nr6!=20 & nr7!=20 & nr8!=20)
		bysort subject: replace drate = 0.1  if (nr1==20 & nr2==20 & nr3==20 & nr4==20 & nr5==20 & nr6==20 & nr7!=20 & nr8!=20)
		bysort subject: replace drate = 0.15 if (nr1==20 & nr2==20 & nr3==20 & nr4==20 & nr5==20 & nr6==20 & nr7==20 & nr8!=20)
		bysort subject: replace drate = 0.2  if (nr1==20 & nr2==20 & nr3==20 & nr4==20 & nr5==20 & nr6==20 & nr7==20 & nr8==20)
		

		// create two types of group: first voter voted yes or else
		drop if period < 1
		bys group: gen fvYes = (firstvoter == 1 & vote == 1 & period == 11)
		bys group: egen fvYesGroup = sum(fvYes) if period == 11
		//bys group subject (period): replace fvYesGroup = fvYesGroup[11] if _n!=11

		label define fvYesGroup 0 "Leader No" 1 "Leader Yes"
		label values fvYesGroup fvYesGroup
		
		
		
	*-> Save Data
		
		save $folder/data/cleaned.dta, replace
		
		log close
