
log using $folder/code/log_2analysis, replace

use $folder/data/cleaned.dta, replace

// fig 2a: winner's bid
preserve
//keep if period > 10
collapse y = max_bid y2 = max_bid_t, by(treatment mgroup)
ranksum y if treatment=="High_TW" | treatment=="Medium_TW", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Zero_W", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Low_W", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Low_T", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Zero_W", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Low_W", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Low_T", by(treatment)
ranksum y if treatment=="Zero_W" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="Low_W" | treatment=="Low_T", by(treatment)
collapse y = y y2 = y2 (semean) b = y , by(treatment)
gen x = 1 if treatment == "High_TW"
replace x = 2 if treatment == "Medium_TW"
replace x = 3 if treatment == "Low_W"
replace x = 4 if treatment == "Low_T"
replace x = 5 if treatment == "Zero_W"
replace x = 6 if treatment == "Zero_T"
gen y_u = y + b
gen y_l = y - b
gen mean_string = string(y, "%2.1f")
twoway (bar y x , barwidth(.6) bfcolor(gs8)) ///
	(rcap y_u y_l x,lcolor(black)) ///
	(connected y2 x, color(gs4) sort) ///
    (scatter y x, msym(none) mlab(mean_string) mlabsize(medium) mlabpos(12) mlabcolor(black) mlabgap(0.1in)), ///
	xtitle("") ytitle("Winner's effort", size(large))  ///
	xlabel(1 "High_TW" 2 "Medium_TW" 3 "Low_W" 4 "Low_T" 5 "Zero_W" 6 "Zero_T") ///
	ylabel(0(50)300, angle(0)) legend(off) scheme(s1mono) scale(0.9) xsize(3) ysize(2.5)
graph export $folder/output/figure2a.png, replace
restore	

// fig 2b: total bid 
preserve
//keep if period > 10
collapse y = total_bid y2 = total_bid_t, by(treatment mgroup)
ranksum y if treatment=="High_TW" | treatment=="Medium_TW", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Zero_W", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Low_W", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Low_T", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Zero_W", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Low_W", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Low_T", by(treatment)
ranksum y if treatment=="Zero_W" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="Low_W" | treatment=="Low_T", by(treatment)
collapse y = y y2 = y2 (semean) b = y , by(treatment)
gen x = 1 if treatment == "High_TW"
replace x = 2 if treatment == "Medium_TW"
replace x = 3 if treatment == "Low_W"
replace x = 4 if treatment == "Low_T"
replace x = 5 if treatment == "Zero_W"
replace x = 6 if treatment == "Zero_T"
gen y_u = y + b
gen y_l = y - b
gen mean_string = string(y, "%2.1f")
twoway (bar y x , barwidth(.6) bfcolor(gs8)) ///
	(rcap y_u y_l x,lcolor(black)) ///
	(connected y2 x, color(gs4) sort) ///
    (scatter y x, msym(none) mlab(mean_string) mlabsize(medium) mlabpos(12) mlabcolor(black) mlabgap(0.17in)), ///
	xtitle("") ytitle("Total effort", size(large))  ///
	xlabel(1 "High_TW" 2 "Medium_TW" 3 "Low_W" 4 "Low_T" 5 "Zero_W" 6 "Zero_T") ///
	ylabel(0(50)300, angle(0)) legend(off) scheme(s1mono) scale(0.9) xsize(3) ysize(2.5)
graph export $folder/output/figure2b.png, replace
restore	

// fig 2c: empircal CDF of winner's bid
distplot max_bid if treatment!="High_Forced" & max_bid<=500, over(tid) scheme(s1color) xla(0(100)500) ///
legend(off) ylabel(0(0.2)1, angle(0))  ///
xsize(3) ysize(2.5) xtitle("") ytitle("Cumulative probability", size(large)) lc(black black gs7 gs7 gs13 gs13) lp(solid solid dash dash longdash longdash) lw(thick medium thick medium thick medium)
graph export $folder/output/figure2c.png, replace

// fig 2d: empircal CDF of total bid
distplot total_bid if treatment!="High_Forced" & total_bid<=800, over(tid) scheme(s1color) xla(0(100)800) ///
legend(lab(1 "High_TW") lab(2 "Medium_TW") lab(3 "Low_W") lab(4 "Low_T") lab(5 "Zero_W") lab(6 "Zero_T") ring(0) pos(4) cols(1)) ylabel(0(0.2)1, angle(0)) ///
xsize(3) ysize(2.5) xtitle("") ytitle("Cumulative probability", size(large)) lc(black black gs7 gs7 gs13 gs13) lp(solid solid dash dash longdash longdash) lw(thick medium thick medium thick medium)
graph export $folder/output/figure2d.png, replace




// fig 3a: bid against ability
twoway (connected av_bid costrate1 if treatment=="High_TW" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected av_bid costrate1 if treatment=="Medium_TW" , sort m(T) lpattern(solid) lcolor(black) mcolor(black)) ///
(connected av_bid costrate1 if treatment=="Low_W" , sort m(S) lpattern(dash) lcolor(gs7) mcolor(gs7) lwidth(thick)) ///
(connected av_bid costrate1 if treatment=="Low_T" , sort m(T) lpattern(dash) lcolor(gs7) mcolor(gs7)) ///
(connected av_bid costrate1 if treatment=="Zero_W" , sort m(S) lpattern(longdash) lcolor(gs13) mcolor(gs13) lwidth(thick)) ///
(connected av_bid costrate1 if treatment=="Zero_T" , sort m(T) lpattern(longdash) lcolor(gs13) mcolor(gs13)) ///
, legend(lab(1 "High_TW") lab(2 "Medium_TW") lab(3 "Low_W") lab(4 "Low_T") lab(5 "Zero_W") lab(6 "Zero_T") ///
col(1) ring(0) pos(11) ) scheme(s1mono) scale(1.2) ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(50)300, labsize(`size') angle(0)) ///
xtitle("Ability", size(`size')) ytitle("Effort", size(`size')) 
graph export $folder/output/figure3a.png, replace

// fig 3b: entry rate against ability
twoway (connected av_enter_cost costrate1 if treatment=="High_TW" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected av_enter_cost costrate1 if treatment=="Medium_TW" , sort m(T) lpattern(solid) lcolor(black) mcolor(black)) ///
(connected av_enter_cost costrate1 if treatment=="Low_W" , sort m(S) lpattern(dash) lcolor(gs7) mcolor(gs7) lwidth(thick)) ///
(connected av_enter_cost costrate1 if treatment=="Low_T" , sort m(T) lpattern(dash) lcolor(gs7) mcolor(gs7)) ///
(connected av_enter_cost costrate1 if treatment=="Zero_W" , sort m(S) lpattern(longdash) lcolor(gs13) mcolor(gs13) lwidth(thick)) ///
(connected av_enter_cost costrate1 if treatment=="Zero_T" , sort m(T) lpattern(longdash) lcolor(gs13) mcolor(gs13)) ///
, legend(off) scheme(s1mono) scale(1.5) ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(20)100, labsize(`size') angle(0)) ///
xtitle("Ability", size(`size')) ytitle("Entry rate (%)", size(`size')) 
graph export $folder/output/figure3b.png, replace

// fig 3c: effort conditional on entry against ability
twoway (connected av_bid_entry_cost costrate1 if treatment=="High_TW" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected av_bid_entry_cost costrate1 if treatment=="Medium_TW" , sort m(T) lpattern(solid) lcolor(black) mcolor(black)) ///
(connected av_bid_entry_cost costrate1 if treatment=="Low_W" , sort m(S) lpattern(dash) lcolor(gs7) mcolor(gs7) lwidth(thick)) ///
(connected av_bid_entry_cost costrate1 if treatment=="Low_T" , sort m(T) lpattern(dash) lcolor(gs7) mcolor(gs7)) ///
(connected av_bid_entry_cost costrate1 if treatment=="Zero_W" , sort m(S) lpattern(longdash) lcolor(gs13) mcolor(gs13) lwidth(thick)) ///
(connected av_bid_entry_cost costrate1 if treatment=="Zero_T" , sort m(T) lpattern(longdash) lcolor(gs13) mcolor(gs13)) ///
, legend(off) scheme(s1mono) scale(1.5) ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(50)300, labsize(`size') angle(0)) ///
xtitle("Ability", size(`size')) ytitle("Effort", size(`size'))
graph export $folder/output/figure3c.png, replace




// fig 4: bid against ability (predicted and observed)
preserve 
collapse y = bid, by(treatment mgroup costrate1)
collapse y = y (semean) b = y , by(treatment costrate1)
gen y_u = y + b
gen y_l = y - b
twoway line y costrate1 if treatment=="High_TW" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick) ///
|| function -3*(40)*x^2 + 2*(40)*x^3 - 120*x^2 + 80*x^3 + 40, range(1.707 2) lcolor(red) ///
|| function 0, range(1 1.707) lcolor(red) ///
|| rcap y_u y_l costrate1 if treatment=="High_TW",lcolor(black) ///
ylabel(, nogrid) ///
ytitle("Effort") xtitle("Ability") ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(50)400, labsize(`size') angle(0)) ///
legend(order(1 "Observed" 2 "Predicted")) scheme(s1mono) title("High_TW")
graph save Graph $folder/output/temp/1.gph, replace

twoway line y costrate1 if treatment=="Medium_TW" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick) ///
|| function -3*(10.5)*x^2 + 2*(10.5)*x^3 - 120*x^2 + 80*x^3 + 40, range(1.455 2) lcolor(red) ///
|| function 0, range(1 1.455) lcolor(red) ///
|| rcap y_u y_l costrate1 if treatment=="Medium_TW",lcolor(black) ///
ylabel(, nogrid) ///
ytitle("Effort") xtitle("Ability") ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(50)400, labsize(`size') angle(0)) ///
legend(order(1 "Observed" 2 "Predicted")) scheme(s1mono) title("Medium_TW")
graph save Graph $folder/output/temp/2.gph, replace

twoway line y costrate1 if treatment=="Low_W" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick) ///
|| function 84*x^3 - 126*x^2 + 45.967, range(1.455 2) lcolor(red) ///
|| function 0, range(1 1.455) lcolor(red) ///
|| rcap y_u y_l costrate1 if treatment=="Low_W",lcolor(black) ///
ylabel(, nogrid) ///
ytitle("Effort") xtitle("Ability") ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(50)400, labsize(`size') angle(0)) ///
legend(order(1 "Observed" 2 "Predicted")) scheme(s1mono) title("Low_W")
graph save Graph $folder/output/temp/3.gph, replace

twoway line y costrate1 if treatment=="Low_T" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick) ///
|| function 84*x^3 - 126*x^2 + 42.436, range(1.218 2) lcolor(red) ///
|| rcap y_u y_l costrate1 if treatment=="Low_T",lcolor(black) ///
ylabel(, nogrid) ///
ytitle("Effort") xtitle("Ability") ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(50)400, labsize(`size') angle(0)) ///
legend(order(1 "Observed" 2 "Predicted")) scheme(s1mono) title("Low_T")
graph save Graph $folder/output/temp/4.gph, replace

twoway line y costrate1 if treatment=="Zero_W" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick) ///
|| function 80*x^3 - 120*x^2 + 43.778, range(1.455 2) lcolor(red) ///
|| function 0, range(1 1.455) lcolor(red) ///
|| rcap y_u y_l costrate1 if treatment=="Zero_W",lcolor(black) ///
ylabel(, nogrid) ///
ytitle("Effort") xtitle("Ability") ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(50)400, labsize(`size') angle(0)) ///
legend(order(1 "Observed" 2 "Predicted")) scheme(s1mono) title("Zero_W")
graph save Graph $folder/output/temp/5.gph, replace

twoway line y costrate1 if treatment=="Zero_T" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick) ///
|| function 80*x^3 - 120*x^2 + 40, range(1 2) lcolor(red) ///
|| rcap y_u y_l costrate1 if treatment=="Zero_T",lcolor(black) ///
ylabel(, nogrid) ///
ytitle("Effort") xtitle("Ability") ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(50)400, labsize(`size') angle(0)) ///
legend(order(1 "Observed" 2 "Predicted")) scheme(s1mono) title("Zero_T")
graph save Graph $folder/output/temp/6.gph, replace

grc1leg2 $folder/output/temp/1.gph $folder/output/temp/2.gph $folder/output/temp/3.gph $folder/output/temp/4.gph $folder/output/temp/5.gph $folder/output/temp/6.gph , ///
scheme(s1mono) cols(3) lcols(4) pos(6) labsize(small) ytol1title xsize(3) ysize(2)

graph export $folder/output/figure4.png, replace
restore




// fig 5a: winner's effort in high_forced
preserve
collapse y = max_bid y2 = max_bid_t, by(treatment mgroup last10)
ranksum y if last10==0 & (treatment=="High_TW" | treatment=="High_Forced"), by(treatment)
ranksum y if last10==1 & (treatment=="High_TW" | treatment=="High_Forced"), by(treatment)
collapse y = y y2 = y2 (semean) b = y , by(treatment last10)
gen x = 1 if treatment == "High_TW" & last10==0
replace x = 2 if treatment == "High_Forced" & last10==0
replace x = 3 if treatment == "High_TW" & last10==1
replace x = 4 if treatment == "High_Forced" & last10==1
gen y_u = y + b
gen y_l = y - b
gen mean_string = string(y, "%2.1f")
twoway (bar y x , barwidth(.6) bfcolor(gs8)) ///
	(rcap y_u y_l x,lcolor(black)) ///
	(connected y2 x, color(gs4) sort) ///
    (scatter y x, msym(none) mlab(mean_string) mlabsize(medium) mlabpos(12) mlabcolor(black) mlabgap(0.1in)), ///
	xtitle("") ytitle("Winner's effort", size(large))  ///
	xlabel(1 "High_TW" 1.5 `" " " " " "First 10 rounds" "' 2 "High_Forced" 3 "High_TW" 3.5 `" " " " " "Last 10 rounds" "' 4 "High_Forced", labsize(medlarge)) ///
	ylabel(0(100)500, angle(0)) legend(off) scheme(s1mono) scale(1) xsize(3) ysize(2.5)
graph export $folder/output/figure5a.png, replace
restore	

// fig 5b: total effort in high_forced
preserve
collapse y = total_bid y2 = total_bid_t, by(treatment mgroup last10)
ranksum y if last10==0 & (treatment=="High_TW" | treatment=="High_Forced"), by(treatment)
ranksum y if last10==1 & (treatment=="High_TW" | treatment=="High_Forced"), by(treatment)
collapse y = y y2 = y2 (semean) b = y , by(treatment last10)
gen x = 1 if treatment == "High_TW" & last10==0
replace x = 2 if treatment == "High_Forced" & last10==0
replace x = 3 if treatment == "High_TW" & last10==1
replace x = 4 if treatment == "High_Forced" & last10==1
gen y_u = y + b
gen y_l = y - b
gen mean_string = string(y, "%2.1f")
twoway (bar y x , barwidth(.6) bfcolor(gs8)) ///
	(rcap y_u y_l x,lcolor(black)) ///
	(connected y2 x, color(gs4) sort) ///
    (scatter y x, msym(none) mlab(mean_string) mlabsize(medium) mlabpos(12) mlabcolor(black) mlabgap(0.1in)), ///
	xtitle("") ytitle("Total effort", size(large))  ///
	xlabel(1 "High_TW" 1.5 `" " " " " "First 10 rounds" "' 2 "High_Forced" 3 "High_TW" 3.5 `" " " " " "Last 10 rounds" "' 4 "High_Forced", labsize(medlarge)) ///
	ylabel(0(100)500, angle(0)) legend(off) scheme(s1mono) scale(1) xsize(3) ysize(2.5)
graph export $folder/output/figure5b.png, replace
restore	




// table 2
use $folder/data/cleaned.dta, replace

drop if treatment=="High_Forced"

* Entry rate percentages by treatment
preserve
collapse (mean) enter=enter (count) n=enter, by(treatment)
gen statistic = "Entry rate"
gen ability = "All"
gen value = string(enter*100, "%5.1f") + "%"
keep treatment statistic ability value
tempfile entry_all
save `entry_all'
restore

* Entry rate by treatment and ability type
preserve
collapse (mean) enter=enter (count) n=enter, by(treatment hightype)
gen statistic = "Entry rate"
gen ability = cond(hightype==1, "High ability", "Low ability")
gen value = string(enter*100, "%5.1f") + "%"
keep treatment statistic ability value
append using `entry_all'
tempfile entry_rates
save `entry_rates'
restore

* Above-cutoff rate if enter
preserve
collapse (mean) abovecutoff=abovecutoff (count) n=abovecutoff if enter==1, by(treatment)
gen statistic = "Above-cutoff rate if enter"
gen ability = "All"
gen value = string(abovecutoff*100, "%5.1f") + "%"
keep treatment statistic ability value
tempfile above_all
save `above_all'
restore

* Above-cutoff by treatment and ability type
preserve
collapse (mean) abovecutoff=abovecutoff (count) n=abovecutoff if enter==1, by(treatment hightype)
gen statistic = "Above-cutoff rate if enter"
gen ability = cond(hightype==1, "High ability", "Low ability")
gen value = string(abovecutoff*100, "%5.1f") + "%"
keep treatment statistic ability value
append using `above_all'
tempfile above_rates
save `above_rates'
restore

* Positive effort below cutoff if enter (assuming bid > 0 means positive effort)
preserve
collapse (mean) positive_effort_below=positive_effort_below (count) n=bid if enter==1, by(treatment)
gen statistic = "Positive effort but below-cutoff rate if enter"
gen ability = "All"
gen value = string(positive_effort_below*100, "%5.1f") + "%"  // Calculate percentage of positive efforts
keep treatment statistic ability value
tempfile positive_all
save `positive_all'
restore

* Positive effort below cutoff if enter by ability type
preserve
collapse (mean) positive_effort_below=positive_effort_below (count) n=bid if enter==1, by(treatment hightype)
gen statistic = "Positive effort but below-cutoff rate if enter"
gen ability = cond(hightype==1, "High ability", "Low ability")
gen value = string(positive_effort_below*100, "%5.1f") + "%"  // Calculate percentage of positive efforts
keep treatment statistic ability value
append using `positive_all'
tempfile positive_rates
save `positive_rates'
restore

* Zero effort if enter
preserve
collapse (mean) effort_zero=effort_zero (count) n=bid if enter==1, by(treatment)
gen statistic = "Zero effort rate if enter"
gen ability = "All"
gen value = string(effort_zero*100, "%5.1f") + "%"  // Calculate percentage of zero efforts
keep treatment statistic ability value
tempfile zero_all
save `zero_all'
restore

* Zero effort if enter by ability type
preserve
collapse (mean) effort_zero=effort_zero (count) n=bid if enter==1, by(treatment hightype)
gen statistic = "Zero effort rate if enter"
gen ability = cond(hightype==1, "High ability", "Low ability")
gen value = string(effort_zero*100, "%5.1f") + "%"  // Calculate percentage of zero efforts
keep treatment statistic ability value
append using `zero_all'
tempfile zero_rates
save `zero_rates'
restore

* Average effort if enter
preserve
collapse (mean) bid=bid (count) n=bid if enter==1, by(treatment)
gen statistic = "Average effort if enter"
gen ability = "All"
gen value = string(bid, "%5.1f")
keep treatment statistic ability value
tempfile effort_all
save `effort_all'
restore

* Average effort by treatment and ability type
preserve
collapse (mean) bid=bid (count) n=bid if enter==1, by(treatment hightype)
gen statistic = "Average effort if enter"
gen ability = cond(hightype==1, "High ability", "Low ability")
gen value = string(bid, "%5.1f")
keep treatment statistic ability value
append using `effort_all'
tempfile effort_rates
save `effort_rates'
restore

* Combine all results
use `entry_rates', clear
append using `above_rates'
append using `positive_rates'
append using `zero_rates'
append using `effort_rates'

* Create a custom order variable to match the exact table layout
gen row_order = .

* Entry rate section
replace row_order = 1 if statistic == "Entry rate" & ability == "All"
replace row_order = 2 if statistic == "Entry rate" & ability == "High ability"
replace row_order = 3 if statistic == "Entry rate" & ability == "Low ability"

* Above-cutoff rate section
replace row_order = 4 if statistic == "Above-cutoff rate if enter" & ability == "All"
replace row_order = 5 if statistic == "Above-cutoff rate if enter" & ability == "High ability"
replace row_order = 6 if statistic == "Above-cutoff rate if enter" & ability == "Low ability"

* Positive effort below cutoff section
replace row_order = 7 if statistic == "Positive effort but below-cutoff rate if enter" & ability == "All"
replace row_order = 8 if statistic == "Positive effort but below-cutoff rate if enter" & ability == "High ability"
replace row_order = 9 if statistic == "Positive effort but below-cutoff rate if enter" & ability == "Low ability"

* Zero effort section
replace row_order = 10 if statistic == "Zero effort rate if enter" & ability == "All"
replace row_order = 11 if statistic == "Zero effort rate if enter" & ability == "High ability"
replace row_order = 12 if statistic == "Zero effort rate if enter" & ability == "Low ability"

* Average effort section
replace row_order = 13 if statistic == "Average effort if enter" & ability == "All"
replace row_order = 14 if statistic == "Average effort if enter" & ability == "High ability"
replace row_order = 15 if statistic == "Average effort if enter" & ability == "Low ability"

* Ensure treatments are in the correct order (assuming they're coded as strings)
* Modify this section if your treatment codes are different
gen treatment_order = .
replace treatment_order = 1 if treatment == "High_TW"
replace treatment_order = 2 if treatment == "Medium_TW"
replace treatment_order = 3 if treatment == "Low_W"
replace treatment_order = 4 if treatment == "Low_T"
replace treatment_order = 5 if treatment == "Zero_W"
replace treatment_order = 6 if treatment == "Zero_T"

* Keep only necessary variables before reshaping
keep row_order statistic ability treatment_order value

* Display the table
reshape wide value, i(row_order statistic ability) j(treatment_order)
sort row_order

* Rename columns to match image headers
rename value1 High_TW
rename value2 Medium_TW
rename value3 Low_W
rename value4 Low_T
rename value5 Zero_W
rename value6 Zero_T

* Display the final table
list statistic ability High_TW Medium_TW Low_W Low_T Zero_W Zero_T, noobs clean





// table 3
use $folder/data/cleaned.dta, replace

xtset sid period

xtprobit enter ib6.tid costrate i.belief female risk_taking competitive crt_score period if treatment!="High_Forced", vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
eststo: xtreg bid ib6.tid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment!="High_Forced" , cluster(mgroup)

xtprobit enter ib6.tid costrate i.belief female risk_taking competitive crt_score period if period>10 & treatment!="High_Forced", vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
eststo: xtreg bid ib6.tid costrate i.belief female risk_taking competitive crt_score period if enter==1 & period>10 & treatment!="High_Forced", cluster(mgroup)

esttab, b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) brackets
esttab using $folder/output/table3.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
estout *, style(tex) cells(b(star fmt(3)) se(par fmt(3))) stats(N) starlevels(* 0.10 ** 0.05 *** 0.01)
eststo clear




// table 4
use $folder/data/cleaned.dta, replace

	* Create a program to calculate and display percentages and means by round groups
program define summary_stats
    args round_filter round_label
	
	keep if treatment=="High_Forced" | treatment=="High_TW"
	keep if `round_filter'
    
    * Entry rate percentages by treatment
    preserve
    collapse (mean) enter=enter (count) n=enter , by(treatment)
    gen statistic = "Entry rate"
    gen ability = "All"
    gen value = string(enter*100, "%5.1f") + "%"
    keep treatment statistic ability value
    tempfile entry_all
    save `entry_all'
    restore
    
    * Entry rate by treatment and ability type
    preserve
    collapse (mean) enter=enter (count) n=enter , by(treatment hightype)
    gen statistic = "Entry rate"
    gen ability = cond(hightype==1, "High ability", "Low ability")
    gen value = string(enter*100, "%5.1f") + "%"
    keep treatment statistic ability value
    append using `entry_all'
    tempfile entry_rates
    save `entry_rates'
    restore
    
    * Above-cutoff rate if enter
    preserve
    collapse (mean) abovecutoff=abovecutoff (count) n=abovecutoff if enter==1 , by(treatment)
    gen statistic = "Above-cutoff rate if enter"
    gen ability = "All"
    gen value = string(abovecutoff*100, "%5.1f") + "%"
    keep treatment statistic ability value
    tempfile above_all
    save `above_all'
    restore
    
    * Above-cutoff by treatment and ability type
    preserve
    collapse (mean) abovecutoff=abovecutoff (count) n=abovecutoff if enter==1 , by(treatment hightype)
    gen statistic = "Above-cutoff rate if enter"
    gen ability = cond(hightype==1, "High ability", "Low ability")
    gen value = string(abovecutoff*100, "%5.1f") + "%"
    keep treatment statistic ability value
    append using `above_all'
    tempfile above_rates
    save `above_rates'
    restore
    
    * Positive effort but below cutoff if enter
    preserve
    collapse (mean) positive_effort_below=positive_effort_below (count) n=bid if enter==1 , by(treatment)
    gen statistic = "Positive effort but below-cutoff rate if enter"
    gen ability = "All"
    gen value = string(positive_effort_below*100, "%5.1f") + "%"
    keep treatment statistic ability value
    tempfile positive_all
    save `positive_all'
    restore
    
    * Positive effort but below cutoff if enter by ability type
    preserve
    collapse (mean) positive_effort_below=positive_effort_below (count) n=bid if enter==1 , by(treatment hightype)
    gen statistic = "Positive effort but below-cutoff rate if enter"
    gen ability = cond(hightype==1, "High ability", "Low ability")
    gen value = string(positive_effort_below*100, "%5.1f") + "%"
    keep treatment statistic ability value
    append using `positive_all'
    tempfile positive_rates
    save `positive_rates'
    restore
    
    * Zero effort if enter
    preserve
    collapse (mean) effort_zero=effort_zero (count) n=bid if enter==1 , by(treatment)
    gen statistic = "Zero effort rate if enter"
    gen ability = "All"
    gen value = string(effort_zero*100, "%5.1f") + "%"
    keep treatment statistic ability value
    tempfile zero_all
    save `zero_all'
    restore
    
    * Zero effort if enter by ability type
    preserve
    collapse (mean) effort_zero=effort_zero (count) n=bid if enter==1 , by(treatment hightype)
    gen statistic = "Zero effort rate if enter"
    gen ability = cond(hightype==1, "High ability", "Low ability")
    gen value = string(effort_zero*100, "%5.1f") + "%"
    keep treatment statistic ability value
    append using `zero_all'
    tempfile zero_rates
    save `zero_rates'
    restore
    
    * Average effort if enter
    preserve
    collapse (mean) bid=bid (count) n=bid if enter==1 , by(treatment)
    gen statistic = "Average effort if enter"
    gen ability = "All"
    gen value = string(bid, "%5.1f")
    keep treatment statistic ability value
    tempfile effort_all
    save `effort_all'
    restore
    
    * Average effort by treatment and ability type
    preserve
    collapse (mean) bid=bid (count) n=bid if enter==1 , by(treatment hightype)
    gen statistic = "Average effort if enter"
    gen ability = cond(hightype==1, "High ability", "Low ability")
    gen value = string(bid, "%5.1f")
    keep treatment statistic ability value
    append using `effort_all'
    tempfile effort_rates
    save `effort_rates'
    restore
    
    * Combine all results
    use `entry_rates', clear
    append using `above_rates'
    append using `positive_rates'
    append using `zero_rates'
    append using `effort_rates'
    
    * Create a custom order variable to match the exact table layout
    gen row_order = .
    
    * Entry rate section
    replace row_order = 1 if statistic == "Entry rate" & ability == "All"
    replace row_order = 2 if statistic == "Entry rate" & ability == "High ability"
    replace row_order = 3 if statistic == "Entry rate" & ability == "Low ability"
    
    * Above-cutoff rate section
    replace row_order = 4 if statistic == "Above-cutoff rate if enter" & ability == "All"
    replace row_order = 5 if statistic == "Above-cutoff rate if enter" & ability == "High ability"
    replace row_order = 6 if statistic == "Above-cutoff rate if enter" & ability == "Low ability"
    
    * Positive effort but below cutoff section
    replace row_order = 7 if statistic == "Positive effort but below-cutoff rate if enter" & ability == "All"
    replace row_order = 8 if statistic == "Positive effort but below-cutoff rate if enter" & ability == "High ability"
    replace row_order = 9 if statistic == "Positive effort but below-cutoff rate if enter" & ability == "Low ability"
    
    * Zero effort section
    replace row_order = 10 if statistic == "Zero effort rate if enter" & ability == "All"
    replace row_order = 11 if statistic == "Zero effort rate if enter" & ability == "High ability"
    replace row_order = 12 if statistic == "Zero effort rate if enter" & ability == "Low ability"
    
    * Average effort section
    replace row_order = 13 if statistic == "Average effort if enter" & ability == "All"
    replace row_order = 14 if statistic == "Average effort if enter" & ability == "High ability"
    replace row_order = 15 if statistic == "Average effort if enter" & ability == "Low ability"
    
    * Ensure treatments are in the correct order
    gen treatment_order = .
    replace treatment_order = 1 if treatment == "High_TW"
    replace treatment_order = 2 if treatment == "High_Forced"
    
    * Keep only necessary variables before reshaping
    keep row_order statistic ability treatment_order value
    
    * Display the table
    reshape wide value, i(row_order statistic ability) j(treatment_order)
    sort row_order
    
    * Rename columns to match image headers
    rename value1 High_TW
    rename value2 High_Forced
    
    * Display the final table
    display as text _newline "*** Results for `round_label' ***" _newline
    list statistic ability High_TW High_Forced, noobs clean
end

* Run the program for first 10 rounds (assuming round variable is called "round")
summary_stats "period <= 10" "First 10 Rounds"

use $folder/data/cleaned.dta, replace

* Run the program for last 10 rounds (assuming 20 total rounds; adjust if different)
summary_stats "period > 10" "Last 10 Rounds"
	
program drop  summary_stats



use $folder/data/cleaned.dta, replace

// fig B1a: winner's bid
preserve
keep if period > 10
collapse y = max_bid y2 = max_bid_t, by(treatment mgroup)
ranksum y if treatment=="High_TW" | treatment=="Medium_TW", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Zero_W", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Low_W", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Low_T", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Zero_W", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Low_W", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Low_T", by(treatment)
ranksum y if treatment=="Zero_W" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="Low_W" | treatment=="Low_T", by(treatment)
collapse y = y y2 = y2 (semean) b = y , by(treatment)
gen x = 1 if treatment == "High_TW"
replace x = 2 if treatment == "Medium_TW"
replace x = 3 if treatment == "Low_W"
replace x = 4 if treatment == "Low_T"
replace x = 5 if treatment == "Zero_W"
replace x = 6 if treatment == "Zero_T"
gen y_u = y + b
gen y_l = y - b
gen mean_string = string(y, "%2.1f")
twoway (bar y x , barwidth(.6) bfcolor(gs8)) ///
	(rcap y_u y_l x,lcolor(black)) ///
	(connected y2 x, color(gs4) sort) ///
    (scatter y x, msym(none) mlab(mean_string) mlabsize(medium) mlabpos(12) mlabcolor(black) mlabgap(0.2in)), ///
	xtitle("") ytitle("Winner's effort", size(large))  ///
	xlabel(1 "High_TW" 2 "Medium_TW" 3 "Low_W" 4 "Low_T" 5 "Zero_W" 6 "Zero_T") ///
	ylabel(0(50)300, angle(0)) legend(off) scheme(s1mono) scale(0.9) xsize(3) ysize(2.5)
graph export $folder/output/figureb1a.png, replace
restore	

// fig B1b: total bid 
preserve
keep if period > 10
collapse y = total_bid y2 = total_bid_t, by(treatment mgroup)
ranksum y if treatment=="High_TW" | treatment=="Medium_TW", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Zero_W", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Low_W", by(treatment)
ranksum y if treatment=="High_TW" | treatment=="Low_T", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Zero_W", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Low_W", by(treatment)
ranksum y if treatment=="Medium_TW" | treatment=="Low_T", by(treatment)
ranksum y if treatment=="Zero_W" | treatment=="Zero_T", by(treatment)
ranksum y if treatment=="Low_W" | treatment=="Low_T", by(treatment)
collapse y = y y2 = y2 (semean) b = y , by(treatment)
gen x = 1 if treatment == "High_TW"
replace x = 2 if treatment == "Medium_TW"
replace x = 3 if treatment == "Low_W"
replace x = 4 if treatment == "Low_T"
replace x = 5 if treatment == "Zero_W"
replace x = 6 if treatment == "Zero_T"
gen y_u = y + b
gen y_l = y - b
gen mean_string = string(y, "%2.1f")
twoway (bar y x , barwidth(.6) bfcolor(gs8)) ///
	(rcap y_u y_l x,lcolor(black)) ///
	(connected y2 x, color(gs4) sort) ///
    (scatter y x, msym(none) mlab(mean_string) mlabsize(medium) mlabpos(12) mlabcolor(black) mlabgap(0.35in)), ///
	xtitle("") ytitle("Total effort", size(large))  ///
	xlabel(1 "High_TW" 2 "Medium_TW" 3 "Low_W" 4 "Low_T" 5 "Zero_W" 6 "Zero_T") ///
	ylabel(0(50)300, angle(0)) legend(off) scheme(s1mono) scale(0.9) xsize(3) ysize(2.5)
graph export $folder/output/figureb1b.png, replace
restore	

// fig B1c: empircal CDF of winner's bid
preserve
keep if period > 10
distplot max_bid if treatment!="High_Forced" & max_bid<=500, over(tid) scheme(s1color) xla(0(100)500) ///
legend(off) ylabel(0(0.2)1, angle(0))  ///
xsize(3) ysize(2.5) xtitle("") ytitle("Cumulative probability", size(large)) lc(black black gs7 gs7 gs13 gs13) lp(solid solid dash dash longdash longdash) lw(thick medium thick medium thick medium)
graph export $folder/output/figureb1c.png, replace
restore

// fig B1d: empircal CDF of total bid
preserve
keep if period > 10
distplot total_bid if treatment!="High_Forced" & total_bid<=800, over(tid) scheme(s1color) xla(0(100)800) ///
legend(lab(1 "High_TW") lab(2 "Medium_TW") lab(3 "Low_W") lab(4 "Low_T") lab(5 "Zero_W") lab(6 "Zero_T") ring(0) pos(4) cols(1)) ylabel(0(0.2)1, angle(0)) ///
xsize(3) ysize(2.5) xtitle("") ytitle("Cumulative probability", size(large)) lc(black black gs7 gs7 gs13 gs13) lp(solid solid dash dash longdash longdash) lw(thick medium thick medium thick medium)
graph export $folder/output/figureb1d.png, replace
restore



// fig B2
twoway (connected max_bid_2 period if treatment=="High_TW" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected max_bid_2 period if treatment=="Medium_TW" , sort m(T) lpattern(solid) lcolor(black) mcolor(black)) ///
(connected max_bid_2 period if treatment=="Low_W" , sort m(S) lpattern(dash) lcolor(gs7) mcolor(gs7) lwidth(thick)) ///
(connected max_bid_2 period if treatment=="Low_T" , sort m(T) lpattern(dash) lcolor(gs7) mcolor(gs7)) ///
(connected max_bid_2 period if treatment=="Zero_W" , sort m(S) lpattern(longdash) lcolor(gs13) mcolor(gs13) lwidth(thick)) ///
(connected max_bid_2 period if treatment=="Zero_T" , sort m(T) lpattern(longdash) lcolor(gs13) mcolor(gs13)) ///
, legend(lab(1 "High_TW") lab(2 "Medium_TW") lab(3 "Low_W") lab(4 "Low_T") lab(5 "Zero_W") lab(6 "Zero_T") ///
col(1) ring(0) pos(4) region(lcolor(none) fcolor(none))) scheme(s1mono) ///
xlabel(1(1)20, labsize(`size') ) ylabel(0(50)250, labsize(`size') angle(0)) ///
xtitle("Round", size(`size')) ytitle("Winner's effort", size(`size')) scale(0.9)

graph export $folder/output/figureb2.png, replace




// fig B3
twoway (connected total_bid_2 period if treatment=="High_TW" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected total_bid_2 period if treatment=="Medium_TW" , sort m(T) lpattern(solid) lcolor(black) mcolor(black)) ///
(connected total_bid_2 period if treatment=="Low_W" , sort m(S) lpattern(dash) lcolor(gs7) mcolor(gs7) lwidth(thick)) ///
(connected total_bid_2 period if treatment=="Low_T" , sort m(T) lpattern(dash) lcolor(gs7) mcolor(gs7)) ///
(connected total_bid_2 period if treatment=="Zero_W" , sort m(S) lpattern(longdash) lcolor(gs13) mcolor(gs13) lwidth(thick)) ///
(connected total_bid_2 period if treatment=="Zero_T" , sort m(T) lpattern(longdash) lcolor(gs13) mcolor(gs13)) ///
, legend(lab(1 "High_TW") lab(2 "Medium_TW") lab(3 "Low_W") lab(4 "Low_T") lab(5 "Zero_W") lab(6 "Zero_T") ///
col(1) ring(0) pos(4) region(lcolor(none) fcolor(none))) scheme(s1mono) ///
xlabel(1(1)20, labsize(`size') ) ylabel(0(50)350, labsize(`size') angle(0)) ///
xtitle("Round", size(`size')) ytitle("Total effort", size(`size')) scale(0.9)

graph export $folder/output/figureb3.png, replace




// fig B4: empirical vs. theoretical CDF of winner's bid
distplot max_bid max_bid_t if treatment=="High_TW" & max_bid<=500, xla(0(100)500) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Winner's effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("High_TW")
graph save Graph $folder/output/temp/1.gph, replace
distplot max_bid max_bid_t if treatment=="Medium_TW" & max_bid<=500, xla(0(100)500) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Winner's effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("Medium_TW")
graph save Graph $folder/output/temp/2.gph, replace
distplot max_bid max_bid_t if treatment=="Low_W" & max_bid<=500, xla(0(100)500) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Winner's effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("Low_W")
graph save Graph $folder/output/temp/3.gph, replace
distplot max_bid max_bid_t if treatment=="Low_T" & max_bid<=500, xla(0(100)500) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Winner's effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("Low_T")
graph save Graph $folder/output/temp/4.gph, replace
distplot max_bid max_bid_t if treatment=="Zero_W" & max_bid<=500, xla(0(100)500) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Winner's effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("Zero_W")
graph save Graph $folder/output/temp/5.gph, replace
distplot max_bid max_bid_t if treatment=="Zero_T" & max_bid<=500, xla(0(100)500) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Winner's effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("Zero_T")
graph save Graph $folder/output/temp/6.gph, replace
grc1leg2 $folder/output/temp/1.gph $folder/output/temp/2.gph $folder/output/temp/3.gph $folder/output/temp/4.gph $folder/output/temp/5.gph $folder/output/temp/6.gph , ///
scheme(s1mono) cols(2) lcols(2) pos(6) labsize(small) ytol1title xsize(2) ysize(3)

graph export $folder/output/figureb4.png, replace




// fig B5: empirical vs. theoretical CDF of total bid
distplot total_bid total_bid_t if treatment=="High_TW" , xla(0(200)800) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("High_TW")
graph save Graph $folder/output/temp/1.gph, replace
distplot total_bid total_bid_t if treatment=="Medium_TW" , xla(0(200)800) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("Medium_TW")
graph save Graph $folder/output/temp/2.gph, replace
distplot total_bid total_bid_t if treatment=="Low_W", xla(0(200)800) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("Low_W")
graph save Graph $folder/output/temp/3.gph, replace
distplot total_bid total_bid_t if treatment=="Low_T" , xla(0(200)800) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("Low_T")
graph save Graph $folder/output/temp/4.gph, replace
distplot total_bid total_bid_t if treatment=="Zero_W", xla(0(200)800) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("Zero_W")
graph save Graph $folder/output/temp/5.gph, replace
distplot total_bid total_bid_t if treatment=="Zero_T" , xla(0(200)800) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("Zero_T")
graph save Graph $folder/output/temp/6.gph, replace
grc1leg2 $folder/output/temp/1.gph $folder/output/temp/2.gph $folder/output/temp/3.gph $folder/output/temp/4.gph $folder/output/temp/5.gph $folder/output/temp/6.gph , ///
scheme(s1mono) cols(2) lcols(2) pos(6) labsize(small) ytol1title xsize(2) ysize(3)

graph export $folder/output/figureb5.png, replace




// fig B6
twoway (connected av_enter period if treatment=="High_TW" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected av_enter period if treatment=="Medium_TW" , sort m(T) lpattern(solid) lcolor(black) mcolor(black)) ///
(connected av_enter period if treatment=="Low_W" , sort m(S) lpattern(dash) lcolor(gs7) mcolor(gs7) lwidth(thick)) ///
(connected av_enter period if treatment=="Low_T" , sort m(T) lpattern(dash) lcolor(gs7) mcolor(gs7)) ///
(connected av_enter period if treatment=="Zero_W" , sort m(S) lpattern(longdash) lcolor(gs13) mcolor(gs13) lwidth(thick)) ///
(connected av_enter period if treatment=="Zero_T" , sort m(T) lpattern(longdash) lcolor(gs13) mcolor(gs13)) ///
, legend(lab(1 "High_TW") lab(2 "Medium_TW") lab(3 "Low_W") lab(4 "Low_T") lab(5 "Zero_W") lab(6 "Zero_T") ///
col(1) ring(0) pos(4) region(lcolor(none) fcolor(none))) scheme(s1mono) ///
xlabel(1(1)20, labsize(`size') ) ylabel(0(20)100, labsize(`size') angle(0)) ///
xtitle("Round", size(`size')) ytitle("Frequency of entry (%)", size(`size')) 

graph export $folder/output/figureb6.png, replace




//fig B7: stacked bar of no entry, bid 0, bid between 0 and cutoff, just above cutoff, other
preserve
gen noenter = 1 - enter 
gen bidzero = (enter==1 & bid == 0)
gen bidbelow = (bid>0 & bid<cutoff)
//gen bidjustabove = (bid> cutoff & bid < cutoff + 3.6)
gen bidabove = (bid > cutoff )
// First, create a numeric variable for ordering
gen tid_order = tid
// Create a value label for tid_order with your custom subtitles
label define tid_labels 1 "High_TW" 2 "Medium_TW" 3 "Low_W" 4 "Low_T" 5 "Zero_W" 6 "Zero_T"
label values tid_order tid_labels
graph bar noenter bidzero bidbelow bidabove if treatment!="High_Forced", ///
over(costrate1) by(tid_order, col(2) note("") iscale(*.8)) stack ///
ytitle(Percentage) scheme(s1mono) xsize(1.3) ysize(2) per b1title("Ability")  ///
bar(1, fcolor(black) fintensity(inten80)) ///
bar(2, fcolor(gray) fintensity(inten60)) ///
bar(3, fcolor(gray) fintensity(inten30)) ///
bar(4, fcolor(gray) fintensity(inten10)) ///
legend(order(4 "effort>cutoff" 3 "0<effort<cutoff" 2 "zero effort" 1 "no entry") pos(3) cols(1)) 

graph export $folder/output/figureb7.png, replace

restore



// fig B8
twoway (connected max_bid_2 period if treatment=="High_Forced" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected max_bid_2 period if treatment=="High_TW" , sort m(T) lpattern(dash) lcolor(black) mcolor(black)) ///
, legend(lab(1 "High_Forced") lab(2 "High_TW")  ///
col(1) ring(0) pos(4) region(lcolor(none) fcolor(none))) scheme(s1mono) ///
xlabel(1(1)20, labsize(`size') ) ylabel(0(50)400, labsize(`size') angle(0)) ///
xtitle("Round", size(`size')) ytitle("Winner's effort", size(`size')) scale(0.9)

graph export $folder/output/figureb8.png, replace




// fig B9
twoway (connected total_bid_2 period if treatment=="High_Forced" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected total_bid_2 period if treatment=="High_TW" , sort m(T) lpattern(dash) lcolor(black) mcolor(black)) ///
, legend(lab(1 "High_Forced") lab(2 "High_TW")  ///
col(1) ring(0) pos(4) region(lcolor(none) fcolor(none))) scheme(s1mono) ///
xlabel(1(1)20, labsize(`size') ) ylabel(0(50)550, labsize(`size') angle(0)) ///
xtitle("Round", size(`size')) ytitle("Total effort", size(`size')) scale(0.9)

graph export $folder/output/figureb9.png, replace




// fig B10a: empircal CDF of winner's bid in High_Forced
gen tid_last10 = 1 if treatment=="High_Forced" & last10==0
replace tid_last10 = 2 if treatment=="High_Forced" & last10==1
replace tid_last10 = 3 if treatment=="High_TW" & last10==0
replace tid_last10 = 4 if treatment=="High_TW" & last10==1
distplot max_bid if (treatment=="High_Forced"|treatment=="High_TW") & max_bid<=500, over(tid_last10) scheme(s1color) xla(0(100)500) ///
legend(off) ///
xsize(1) ysize(1) xtitle("Winner's effort") lc(black black gs11 gs11) lp(solid solid dash dash ) lw(thick medium thick medium)

graph export $folder/output/figureb10a.png, replace




// fig B10b: empircal CDF of total bid in High_Forced
distplot total_bid if (treatment=="High_Forced"|treatment=="High_TW") & total_bid<=800, over(tid_last10) scheme(s1color) xla(0(100)800) ///
legend(lab(1 "High_Forced (first 10)") lab(2 "High_Forced (last 10)") lab(3 "High_TW (first 10 )") lab(4 "High_TW (last 10)") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") lc(black black gs7 gs7 gs13 gs13) lp(solid solid dash dash longdash longdash) lw(thick medium thick medium thick medium)

graph export $folder/output/figureb10b.png, replace




// fig B11: empirical vs. theoretical CDF of winner's bid in High_Forced
distplot max_bid max_bid_t if treatment=="High_Forced" & max_bid<=500 & period<=10, xla(0(100)500) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Winner's effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("High_Forced")
graph save Graph $folder/output/temp/1.gph, replace
distplot max_bid max_bid_t if treatment=="High_Forced" & max_bid<=500 & period>10, xla(0(100)500) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Winner's effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("High_Forced")
graph save Graph $folder/output/temp/2.gph, replace
distplot max_bid max_bid_t if treatment=="High_TW" & max_bid<=500 & period<=10, xla(0(100)500) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Winner's effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("High_TW")
graph save Graph $folder/output/temp/3.gph, replace
distplot max_bid max_bid_t if treatment=="High_TW" & max_bid<=500 & period>10, xla(0(100)500) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Winner's effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("High_TW")
graph save Graph $folder/output/temp/4.gph, replace
grc1leg2 $folder/output/temp/1.gph $folder/output/temp/2.gph $folder/output/temp/3.gph $folder/output/temp/4.gph , ///
scheme(s1mono) cols(2) lcols(2) pos(6) labsize(small) ytol1title xsize(1.8) ysize(2) title("First 10 rounds          Last 10 rounds")

graph export $folder/output/figureb11.png, replace




// fig B12: empirical vs. theoretical CDF of total bid in High_Forced
distplot total_bid total_bid_t if treatment=="High_Forced" & total_bid<=800 & period<=10, xla(0(200)800) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("High_Forced")
graph save Graph $folder/output/temp/1.gph, replace
distplot total_bid total_bid_t if treatment=="High_Forced" & total_bid<=800 & period>10, xla(0(200)800) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("High_Forced")
graph save Graph $folder/output/temp/2.gph, replace
distplot total_bid total_bid_t if treatment=="High_TW" & total_bid<=800 & period<=10, xla(0(200)800) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("High_TW")
graph save Graph $folder/output/temp/3.gph, replace
distplot total_bid total_bid_t if treatment=="High_TW" & total_bid<=800 & period>10, xla(0(200)800) ///
legend(lab(1 "Observed") lab(2 "Predicted") ring(0) pos(4) cols(1)) ///
xsize(1) ysize(1) xtitle("Total effort") scheme(s1mono) lc(black gs7) lp(solid dash) lw(medium medium) ///
title("High_TW")
graph save Graph $folder/output/temp/4.gph, replace
grc1leg2 $folder/output/temp/1.gph $folder/output/temp/2.gph $folder/output/temp/3.gph $folder/output/temp/4.gph , ///
scheme(s1mono) cols(2) lcols(2) pos(6) labsize(small) ytol1title xsize(1.8) ysize(2) title("First 10 rounds          Last 10 rounds")

graph export $folder/output/figureb12.png, replace




// fig B13: frequency of entering the contest in High_Forced
twoway (connected av_enter period if treatment=="High_TW" , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected av_enter period if treatment=="High_Forced" , sort m(T) lpattern(dash) lcolor(black) mcolor(black)) ///
, legend(lab(1 "High_TW") lab(2 "High_Forced")  ///
col(1) ring(0) pos(4) region(lcolor(none) fcolor(none))) scheme(s1mono) ///
xlabel(1(1)20, labsize(`size') ) ylabel(0(20)100, labsize(`size') angle(0)) ///
xtitle("Round", size(`size')) ytitle("Frequency of entry (%)", size(`size')) scale(0.9)

graph export $folder/output/figureb13.png, replace




// fig B14a: bid against ability in high_forced
bys treatment costrate1 last10: egen av_bid2 = mean(bid)
twoway (connected av_bid2 costrate1 if treatment=="High_Forced" & last10==0 , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected av_bid2 costrate1 if treatment=="High_Forced" & last10==1 , sort m(T) lpattern(solid) lcolor(black) mcolor(black)) ///
(connected av_bid2 costrate1 if treatment=="High_TW" & last10==0 , sort m(S) lpattern(dash) lcolor(gs11) mcolor(gs11) lwidth(thick)) ///
(connected av_bid2 costrate1 if treatment=="High_TW" & last10==1 , sort m(T) lpattern(dash) lcolor(gs11) mcolor(gs11)) ///
, legend(lab(1 "High_Forced (first 10 rounds)") lab(2 "High_Forced (last 10 rounds)") lab(3 "High_TW (first 10 rounds)") lab(4 "High_TW (last 10 rounds)") ///
col(1) ring(0) pos(11) ) scheme(s1mono) scale(1.2) ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(50)300, labsize(`size') angle(0)) ///
xtitle("Ability", size(`size')) ytitle("Effort", size(`size')) 

graph export $folder/output/figureb14a.png, replace

// fig B14b: entry rate against ability
bys treatment costrate1 last10: egen av_enter_cost2 = mean(enter*100)
twoway (connected av_enter_cost2 costrate1 if treatment=="High_Forced" & last10==0 , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected av_enter_cost2 costrate1 if treatment=="High_Forced" & last10==1 , sort m(T) lpattern(solid) lcolor(black) mcolor(black)) ///
(connected av_enter_cost2 costrate1 if treatment=="High_TW" & last10==0 , sort m(S) lpattern(dash) lcolor(gs11) mcolor(gs11) lwidth(thick)) ///
(connected av_enter_cost2 costrate1 if treatment=="High_TW" & last10==1 , sort m(T) lpattern(dash) lcolor(gs11) mcolor(gs11)) ///
, legend(off) scheme(s1mono) scale(1.5) ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(20)100, labsize(`size') angle(0)) ///
xtitle("Ability", size(`size')) ytitle("Entry rate (%)", size(`size')) 

graph export $folder/output/figureb14b.png, replace

// fig B14c: effort conditional on entry against ability
bys treatment costrate1 last10: egen av_bid_entry_cost2 = mean(bid) if enter==1
twoway (connected av_bid_entry_cost2 costrate1 if treatment=="High_Forced" & last10==0 , sort m(S) lpattern(solid) lcolor(black) mcolor(black) lwidth(thick)) ///
(connected av_bid_entry_cost2 costrate1 if treatment=="High_Forced" & last10==1 , sort m(T) lpattern(solid) lcolor(black) mcolor(black)) ///
(connected av_bid_entry_cost2 costrate1 if treatment=="High_TW" & last10==0 , sort m(S) lpattern(dash) lcolor(gs11) mcolor(gs11) lwidth(thick)) ///
(connected av_bid_entry_cost2 costrate1 if treatment=="High_TW" & last10==1 , sort m(T) lpattern(dash) lcolor(gs11) mcolor(gs11)) ///
, legend(off) scheme(s1mono) scale(1.5) ///
xlabel(1(0.2)2, labsize(`size') ) ylabel(0(50)300, labsize(`size') angle(0)) ///
xtitle("Ability", size(`size')) ytitle("Effort", size(`size'))

graph export $folder/output/figureb14c.png, replace




// table B2
use $folder/data/cleaned.dta, replace
preserve
drop if treatment=="High_Forced"
bys tid period gid: gen n=_n
keep if n==1
xtset gid period
eststo: xtreg max_bid ib6.tid period, cluster(mgroup)
test 1.tid = 2.tid
test 1.tid = 3.tid
test 1.tid = 4.tid
test 1.tid = 5.tid
test 2.tid = 3.tid
test 2.tid = 4.tid
test 2.tid = 5.tid
test 3.tid = 4.tid
test 3.tid = 5.tid
eststo: xtreg max_bid ib6.tid period if period > 10, cluster(mgroup)
test 1.tid = 2.tid
test 1.tid = 3.tid
test 1.tid = 4.tid
test 1.tid = 5.tid
test 2.tid = 3.tid
test 2.tid = 4.tid
test 2.tid = 5.tid
test 3.tid = 4.tid
test 3.tid = 5.tid
eststo: xtreg total_bid ib6.tid period, cluster(mgroup)
test 1.tid = 2.tid
test 1.tid = 3.tid
test 1.tid = 4.tid
test 1.tid = 5.tid
test 2.tid = 3.tid
test 2.tid = 4.tid
test 2.tid = 5.tid
test 3.tid = 4.tid
test 3.tid = 5.tid
eststo: xtreg total_bid ib6.tid period if period > 10, cluster(mgroup)
test 1.tid = 2.tid
test 1.tid = 3.tid
test 1.tid = 4.tid
test 1.tid = 5.tid
test 2.tid = 3.tid
test 2.tid = 4.tid
test 2.tid = 5.tid
test 3.tid = 4.tid
test 3.tid = 5.tid
esttab using $folder/output/tableb2.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
estout *, style(tex) cells(b(star fmt(3)) se(par fmt(3))) stats(N) starlevels(* 0.10 ** 0.05 *** 0.01)
eststo clear
restore



// table B3

use $folder/data/cleaned.dta, replace

drop if treatment=="High_Forced"
keep if period>10

* Entry rate percentages by treatment
preserve
collapse (mean) enter=enter (count) n=enter, by(treatment)
gen statistic = "Entry rate"
gen ability = "All"
gen value = string(enter*100, "%5.1f") + "%"
keep treatment statistic ability value
tempfile entry_all
save `entry_all'
restore

* Entry rate by treatment and ability type
preserve
collapse (mean) enter=enter (count) n=enter, by(treatment hightype)
gen statistic = "Entry rate"
gen ability = cond(hightype==1, "High ability", "Low ability")
gen value = string(enter*100, "%5.1f") + "%"
keep treatment statistic ability value
append using `entry_all'
tempfile entry_rates
save `entry_rates'
restore

* Above-cutoff rate if enter
preserve
collapse (mean) abovecutoff=abovecutoff (count) n=abovecutoff if enter==1, by(treatment)
gen statistic = "Above-cutoff rate if enter"
gen ability = "All"
gen value = string(abovecutoff*100, "%5.1f") + "%"
keep treatment statistic ability value
tempfile above_all
save `above_all'
restore

* Above-cutoff by treatment and ability type
preserve
collapse (mean) abovecutoff=abovecutoff (count) n=abovecutoff if enter==1, by(treatment hightype)
gen statistic = "Above-cutoff rate if enter"
gen ability = cond(hightype==1, "High ability", "Low ability")
gen value = string(abovecutoff*100, "%5.1f") + "%"
keep treatment statistic ability value
append using `above_all'
tempfile above_rates
save `above_rates'
restore

* Positive effort below cutoff if enter (assuming bid > 0 means positive effort)
preserve
collapse (mean) positive_effort_below=positive_effort_below (count) n=bid if enter==1, by(treatment)
gen statistic = "Positive effort but below-cutoff rate if enter"
gen ability = "All"
gen value = string(positive_effort_below*100, "%5.1f") + "%"  // Calculate percentage of positive efforts
keep treatment statistic ability value
tempfile positive_all
save `positive_all'
restore

* Positive effort below cutoff if enter by ability type
preserve
collapse (mean) positive_effort_below=positive_effort_below (count) n=bid if enter==1, by(treatment hightype)
gen statistic = "Positive effort but below-cutoff rate if enter"
gen ability = cond(hightype==1, "High ability", "Low ability")
gen value = string(positive_effort_below*100, "%5.1f") + "%"  // Calculate percentage of positive efforts
keep treatment statistic ability value
append using `positive_all'
tempfile positive_rates
save `positive_rates'
restore

* Zero effort if enter
preserve
collapse (mean) effort_zero=effort_zero (count) n=bid if enter==1, by(treatment)
gen statistic = "Zero effort rate if enter"
gen ability = "All"
gen value = string(effort_zero*100, "%5.1f") + "%"  // Calculate percentage of zero efforts
keep treatment statistic ability value
tempfile zero_all
save `zero_all'
restore

* Zero effort if enter by ability type
preserve
collapse (mean) effort_zero=effort_zero (count) n=bid if enter==1, by(treatment hightype)
gen statistic = "Zero effort rate if enter"
gen ability = cond(hightype==1, "High ability", "Low ability")
gen value = string(effort_zero*100, "%5.1f") + "%"  // Calculate percentage of zero efforts
keep treatment statistic ability value
append using `zero_all'
tempfile zero_rates
save `zero_rates'
restore

* Average effort if enter
preserve
collapse (mean) bid=bid (count) n=bid if enter==1, by(treatment)
gen statistic = "Average effort if enter"
gen ability = "All"
gen value = string(bid, "%5.1f")
keep treatment statistic ability value
tempfile effort_all
save `effort_all'
restore

* Average effort by treatment and ability type
preserve
collapse (mean) bid=bid (count) n=bid if enter==1, by(treatment hightype)
gen statistic = "Average effort if enter"
gen ability = cond(hightype==1, "High ability", "Low ability")
gen value = string(bid, "%5.1f")
keep treatment statistic ability value
append using `effort_all'
tempfile effort_rates
save `effort_rates'
restore

* Combine all results
use `entry_rates', clear
append using `above_rates'
append using `positive_rates'
append using `zero_rates'
append using `effort_rates'

* Create a custom order variable to match the exact table layout
gen row_order = .

* Entry rate section
replace row_order = 1 if statistic == "Entry rate" & ability == "All"
replace row_order = 2 if statistic == "Entry rate" & ability == "High ability"
replace row_order = 3 if statistic == "Entry rate" & ability == "Low ability"

* Above-cutoff rate section
replace row_order = 4 if statistic == "Above-cutoff rate if enter" & ability == "All"
replace row_order = 5 if statistic == "Above-cutoff rate if enter" & ability == "High ability"
replace row_order = 6 if statistic == "Above-cutoff rate if enter" & ability == "Low ability"

* Positive effort below cutoff section
replace row_order = 7 if statistic == "Positive effort but below-cutoff rate if enter" & ability == "All"
replace row_order = 8 if statistic == "Positive effort but below-cutoff rate if enter" & ability == "High ability"
replace row_order = 9 if statistic == "Positive effort but below-cutoff rate if enter" & ability == "Low ability"

* Zero effort section
replace row_order = 10 if statistic == "Zero effort rate if enter" & ability == "All"
replace row_order = 11 if statistic == "Zero effort rate if enter" & ability == "High ability"
replace row_order = 12 if statistic == "Zero effort rate if enter" & ability == "Low ability"

* Average effort section
replace row_order = 13 if statistic == "Average effort if enter" & ability == "All"
replace row_order = 14 if statistic == "Average effort if enter" & ability == "High ability"
replace row_order = 15 if statistic == "Average effort if enter" & ability == "Low ability"

* Ensure treatments are in the correct order (assuming they're coded as strings)
* Modify this section if your treatment codes are different
gen treatment_order = .
replace treatment_order = 1 if treatment == "High_TW"
replace treatment_order = 2 if treatment == "Medium_TW"
replace treatment_order = 3 if treatment == "Low_W"
replace treatment_order = 4 if treatment == "Low_T"
replace treatment_order = 5 if treatment == "Zero_W"
replace treatment_order = 6 if treatment == "Zero_T"

* Keep only necessary variables before reshaping
keep row_order statistic ability treatment_order value

* Display the table
reshape wide value, i(row_order statistic ability) j(treatment_order)
sort row_order

* Rename columns to match image headers
rename value1 High_TW
rename value2 Medium_TW
rename value3 Low_W
rename value4 Low_T
rename value5 Zero_W
rename value6 Zero_T

* Display the final table
list statistic ability High_TW Medium_TW Low_W Low_T Zero_W Zero_T, noobs clean






// table B4
use $folder/data/cleaned.dta, replace

gen sumenter_other = sumenter - enter
bys sessionid treatment subject (period): gen l_enter = enter[_n-1]
bys sessionid treatment subject (period): gen l_sumenter_other = sumenter_other[_n-1]

xtset sid period
xtprobit enter ib6.tid costrate i.belief l_enter l_sumenter_other female risk_taking competitive crt_score period if treatment!="High_Forced", vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
eststo: xtreg bid ib6.tid costrate i.belief l_enter l_sumenter_other female risk_taking competitive crt_score period if enter==1 & treatment!="High_Forced" , cluster(mgroup)

xtprobit enter ib6.tid costrate i.belief l_enter l_sumenter_other female risk_taking competitive crt_score period if period>10 & treatment!="High_Forced", vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
eststo: xtreg bid ib6.tid costrate i.belief l_enter l_sumenter_other female risk_taking competitive crt_score period if enter==1 & period>10 & treatment!="High_Forced", cluster(mgroup)

esttab, b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) brackets
esttab using $folder/output/tableb4.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
estout *, style(tex) cells(b(star fmt(3)) se(par fmt(3))) stats(N) starlevels(* 0.10 ** 0.05 *** 0.01)
eststo clear





// table B5
use $folder/data/cleaned.dta, replace

xtset sid period
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="High_TW", vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Medium_TW", vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Low_W", vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Low_T", vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Zero_W", vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Zero_T", vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post

eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="High_TW", cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Medium_TW", cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Low_W", cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Low_T", cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Zero_W", cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Zero_T", cluster(mgroup)
esttab using $folder/output/tableb5.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
estout *, style(tex) cells(b(star fmt(3)) se(par fmt(3))) stats(N) starlevels(* 0.10 ** 0.05 *** 0.01)
eststo clear


// Table B6
use $folder/data/cleaned.dta, replace

xtset sid period
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="High_TW" & hightype==1, vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Medium_TW" & hightype==1, vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Low_W" & hightype==1, vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Low_T" & hightype==1, vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Zero_W" & hightype==1, vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post

eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="High_TW" & hightype==1, cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Medium_TW" & hightype==1, cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Low_W" & hightype==1, cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Low_T" & hightype==1, cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Zero_W" & hightype==1, cluster(mgroup)
esttab using $folder/output/tableb6.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
estout *, style(tex) cells(b(star fmt(3)) se(par fmt(3))) stats(N) starlevels(* 0.10 ** 0.05 *** 0.01)
eststo clear


// Table B7
use $folder/data/cleaned.dta, replace

xtset sid period
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="High_TW" & hightype==0, vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Medium_TW" & hightype==0, vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Low_W" & hightype==0, vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Low_T" & hightype==0, vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post
xtprobit enter costrate i.belief female risk_taking competitive crt_score period if treatment=="Zero_W" & hightype==0, vce(cluster mgroup)
eststo: margins, predict(pu0) dydx(*) post

eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="High_TW" & hightype==0, cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Medium_TW" & hightype==0, cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Low_W" & hightype==0, cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Low_T" & hightype==0, cluster(mgroup)
eststo: xtreg bid costrate i.belief female risk_taking competitive crt_score period if enter==1 & treatment=="Zero_W" & hightype==0, cluster(mgroup)
esttab using $folder/output/tableb7.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
estout *, style(tex) cells(b(star fmt(3)) se(par fmt(3))) stats(N) starlevels(* 0.10 ** 0.05 *** 0.01)
eststo clear


// Table B8
use $folder/data/cleaned.dta, replace

keep if treatment=="High_Forced" | treatment=="High_TW"
bys tid period gid: gen n=_n
keep if n==1
xtset gid period
eststo: xtreg max_bid ib1.tid period if period<=10, cluster(mgroup)
eststo: xtreg max_bid ib1.tid period if period>10, cluster(mgroup)
eststo: xtreg total_bid ib1.tid period if period<=10, cluster(mgroup)
eststo: xtreg max_bid ib1.tid period if period>10, cluster(mgroup)
esttab using $folder/output/tableb8.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
estout *, style(tex) cells(b(star fmt(3)) se(par fmt(3))) stats(N) starlevels(* 0.10 ** 0.05 *** 0.01)
eststo clear




// Table B9
use $folder/data/cleaned.dta, replace

xtset sid period
eststo: xtreg bid ib1.tid costrate i.belief female risk_taking competitive crt_score period if enter==1 & (treatment=="High_Forced"|treatment=="High_TW") & period<=10 , cluster(mgroup)
esttab using $folder/output/tableb9.tex, replace b(%6.3f) se star(* 0.10 ** 0.05 *** 0.01) booktabs
estout *, style(tex) cells(b(star fmt(3)) se(par fmt(3))) stats(N) starlevels(* 0.10 ** 0.05 *** 0.01)
eststo clear


log close

