# README for "Born to wait? A study on allocation rules in booking systems" (Lingbo Huang, Tracy Xiao Liu, Jun Zhang)

## Overview

This replication package contains all materials needed to replicate the experimental findings reported in "Born to wait? A study on allocation rules in booking systems." The package includes:

- Experimental data from Experiment 1 comparing queue-based and lottery-based allocation rules
- STATA code for data cleaning and analysis
- Experimental software files (z-Tree programs)
- All figures and tables referenced in the manuscript and appendix B

## Data Availability and Provenance Statements

### Statement about Rights

- [X] I certify that the author(s) of the manuscript have legitimate access to and permission to use the data used in this manuscript.
- [X] I certify that the author(s) of the manuscript have documented permission to redistribute/publish the data contained within this replication package.

### Summary of Availability

- [X] All experimental data **are** provided as part of this replication package.

### Data Sources

**Raw Data Files (INPUT):**
- `data/raw/masterdata_exp1.dta`: Raw master dataset from Experiment 1
- `data/raw/switch_data_exp1.dta`: Raw switching behavior data from Experiment 1

**Cleaned Data Files (OUTPUT - generated automatically):**
- `data/derived/masterdata_exp1_clean.dta`: Cleaned data from Experiment 1
- `data/derived/switch_data_exp1_clean.dta`: Cleaned switching behavior data from Experiment 1

**Experimental Session Data:**
- `experimental-materials/raw-output-from-ztree/`: Raw z-Tree output files organized by treatment:
  - `lottery5/`: Raw output from Lottery5 treatment (3 sessions)
  - `queue5/`: Raw output from Queue5 treatment (3 sessions)
  - `queue5_rank/`: Raw output from Queue5_rank treatment (3 sessions)

Each session directory contains:
- `.xls` files: Subject-level data (contracts, globals, subjects, summary, etc.)
- `.ztt` files: z-Tree program files
- `.sbj` files: Subject assignment files
- Database files: `@db.txt`, `@lastclt.txt`, `@prevdb.txt`, `server.eec`

**Experimental Software:**
- `experimental-materials/software/Lottery5.ztt`: z-Tree program for Lottery5 treatment
- `experimental-materials/software/Queue5.ztt`: z-Tree program for Queue5 treatment
- `experimental-materials/software/Queue5_rank.ztt`: z-Tree program for Queue5_rank treatment

## Computational Requirements

### Software Requirements

- **Stata** (version 16 or later recommended)
  - Required packages: `estout` (automatically installed by 0PathSetup.do)

- **z-Tree** (for experimental software, version 3.6.7 or later recommended)
  - Required to run the experimental programs
  - Not required for data analysis

### Memory, Runtime, Storage Requirements

**Summary time to reproduce:**
- [X] 5 minutes (data cleaning and analysis)

**Summary of required storage space:**
- [X] 25 MB - 50 MB

**Computational Details:**
The code was last run on a standard laptop with macOS. The analysis is computationally light and can be run on any modern computer with Stata installed.

## Description of Programs/Code

The replication package uses a simple two-file structure:

**`code/0PathSetup.do`**: Path setup file (RUN FIRST)
   - Sets up all global paths for the replication package
   - Installs required packages (estout)

**`code/1Analysis.do`**: Master analysis file (RUN AFTER 0PathSetup.do)
   - Processes raw data from `data/raw/masterdata_exp1.dta` and `data/raw/switch_data_exp1.dta`
   - Generates cleaned datasets: `data/derived/masterdata_exp1_clean.dta` and `data/derived/switch_data_exp1_clean.dta`
   - Generates **ALL Main Manuscript Figures 1-4 and Tables 3-6**
   - Generates **ALL Appendix B Figures B1-B2 and Tables B1-B2**

## Instructions to Replicators

To replicate the analysis:

1. **Set up the working directory:**
   - Open Stata and set the working directory to the package root:
   ```stata
   cd "/path/to/2025-booking-software-data"
   ```

2. **Run the path setup file:**
   ```stata
   do code/0PathSetup.do
   ```
   This will:
   - Set up all global paths
   - Install required packages (estout)

3. **Run the analysis file:**
   ```stata
   do code/1Analysis.do
   ```
   This will:
   - Process raw data from `data/raw/` (both master and switch data)
   - Generate cleaned datasets in `data/derived/`
   - Create ALL figures and tables from the main manuscript (Figure 1-4, Table 3-6)
   - Create ALL figures and tables from Appendix B (Figure B1-B2, Table B1-B2)

**Note:** All figures and tables are automatically numbered according to manuscript conventions:
- Main manuscript: Figure 1-4, Table 3-6
- Appendix B: Figure B1-B2, Table B1-B2

## List of Tables and Figures

### Main Manuscript

**Tables:**
- Table 3: Random effects regressions on time spent in booking (`output/tables/table3.tex`)
- Table 4: Random effects probit regressions on likelihood of obtaining a slot - **marginal effects only** (`output/tables/table4.tex`)
- Table 5: Random effects probit regressions on bimodal behavior - **marginal effects only** (`output/tables/table5.tex`)
- Table 6: The Breakdown of Efficiency Loss (`output/tables/table6.tex`)

**Figures:**
- Figure 1: Percentage of time spent on the booking system (`output/figures/figure1.png`)
- Figure 2: Relationship between time valuation and percentage of queuing time (`output/figures/figure2.png`)
- Figure 3: CDF of percentage of total queuing time (`output/figures/figure3_left.png`, `figure3_right.png`)
- Figure 4: CDF of percentage of effective queuing time (`output/figures/figure4_left.png`, `figure4_right.png`)

### Appendix B (E-Companion)

**Appendix B Tables:**
- Table B1: Switching frequency regressions (`output/tables/tableB1.tex`)
- Table B2: Effective queuing time regressions (`output/tables/tableB2.tex`)

**Appendix B Figures:**
- Figure B1: The evolution of percentage of time spent on the booking system (`output/figures/figureB1.png`)
- Figure B2: The evolution of effective and ineffective queuing time (`output/figures/figureB2.png`)

## Data Dictionary

Key variables in the analysis datasets:

- `treatment`: Treatment indicator (Lottery5, Queue5, Queue5_rank)
- `valuation`: Participant's valuation for a booking slot (400-600 ECUs)
- `time_cost`: Participant's per-second productivity (1.50-2.50 ECUs/second)
- `time_val`: Ratio of slot valuation to opportunity cost of time
- `slot`: Binary indicator (1 if participant obtained a slot)
- `time_book_per`: Percentage of time spent in the booking system
- `time_spent_booking_step1`: Total time spent in the booking system (in seconds)
- `period`: Round number (1-8)
- `subject`: Participant identifier within session
- `sessionid`: Experimental session identifier
- `mgroup`: Group identifier (constructed from session and group)

## References
